#include "concurrenttransfersselector.h"
#include "../shared/selectionmodels.h"
#include <QMaemo5ListPickSelector>

ConcurrentTransfersSelector::ConcurrentTransfersSelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new ConcurrentTransfersModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    m_selector->setModel(m_model);
    m_selector->setModelColumn(0);
    this->setPickSelector(m_selector);
    this->connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void ConcurrentTransfersSelector::setValue(int value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = m_model->value(i).toInt() == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

int ConcurrentTransfersSelector::currentValue() {
    return m_model->value(m_selector->currentIndex()).toInt();
}

void ConcurrentTransfersSelector::onSelected() {
    emit valueChanged(this->currentValue());
}
