#ifndef TREEVIEW_H
#define TREEVIEW_H

#include <QTreeView>
#include <QMouseEvent>

class TreeView : public QTreeView
{
    Q_OBJECT

public:
    explicit TreeView(QWidget *parent = 0);

protected:
    void mouseMoveEvent(QMouseEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    
signals:
    void rowEntered(int row);
    void rowPressed(int row);
    void rowReleased(int row);
    void rowClicked(int row);
    
private:
    int m_pressedRow;
};

#endif // TREEVIEW_H
