#include "transfertitledelegate.h"
#include "../shared/transfermodel.h"
#include <QPainter>

TransferTitleDelegate::TransferTitleDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferTitleDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if (index.data(TransferModel::SelectedRole).toBool()) {
        painter->fillRect(option.rect, Qt::cyan);
    }
    else if (index.data(TransferModel::EnteredRole).toBool()) {
        painter->fillRect(option.rect, Qt::lightGray);
    }

    QRect imageRect = option.rect;
    imageRect.setSize(QSize(19, 19));
    imageRect.moveTopLeft(QPoint(imageRect.left() + 3, imageRect.top() + 3));

    QString serviceIcon = index.data(TransferModel::ServiceIconRole).toString();

    if (serviceIcon.isEmpty()) {
        QIcon::fromTheme("unknown").paint(painter, imageRect);
    }
    else {
        painter->drawImage(imageRect, QImage("/opt/qdl/icons/" + serviceIcon).scaled(imageRect.size(), Qt::KeepAspectRatio, Qt::SmoothTransformation));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 25);

    painter->drawText(textRect, Qt::AlignVCenter, index.data(TransferModel::FileNameRole).toString());
}

QSize TransferTitleDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 25);
}
