#include "transferstatusdelegate.h"
#include "../shared/transfermodel.h"
#include "../shared/utils.h"
#include <QPainter>

TransferStatusDelegate::TransferStatusDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferStatusDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();
    if (index.data(TransferModel::SelectedRole).toBool()) {
        painter->fillRect(option.rect, Qt::cyan);
    }
    else if (index.data(TransferModel::EnteredRole).toBool()) {
        painter->fillRect(option.rect, Qt::lightGray);
    }

    QRect statusRect = option.rect;
    Transfers::Status status = static_cast<Transfers::Status>(index.data(TransferModel::StatusRole).toInt());

    switch (status) {
    case Transfers::Failed:
        painter->drawText(statusRect, Qt::AlignHCenter, index.data(TransferModel::StatusTextRole).toString());
        painter->setPen(Qt::red);
        painter->drawText(statusRect, Qt::AlignBottom | Qt::AlignHCenter, index.data(TransferModel::StatusInfoRole).toString());
        break;
    case Transfers::ShortWait:
        painter->drawText(statusRect, Qt::AlignHCenter, index.data(TransferModel::StatusTextRole).toString());
        painter->setPen(Qt::red);
        painter->drawText(statusRect, Qt::AlignBottom | Qt::AlignHCenter, index.data(TransferModel::StatusInfoRole).toString());
        break;
    case Transfers::LongWait:
        painter->drawText(statusRect, Qt::AlignHCenter, index.data(TransferModel::StatusTextRole).toString());
        painter->setPen(Qt::red);
        painter->drawText(statusRect, Qt::AlignBottom | Qt::AlignHCenter, index.data(TransferModel::StatusInfoRole).toString());
        break;
    default:
        painter->drawText(statusRect, Qt::AlignCenter, index.data(TransferModel::StatusTextRole).toString());
    }

    painter->restore();
}

QSize TransferStatusDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 25);
}
