#include "checkurlsdialog.h"
#include <QGridLayout>
#include <QTreeWidgetItem>
#include <QDebug>

CheckUrlsDialog::CheckUrlsDialog(Session *session, QWidget *parent) :
    QDialog(parent),
    m_session(session),
    m_view(new QTreeWidget(this)),
    m_progressBar(new QProgressBar(this)),
    m_infoLabel(new QLabel(QString("<i>%1</i>").arg(tr("Checking URLs")), this)),
    m_buttonBox(new QDialogButtonBox(Qt::Horizontal, this)),
    m_okButton(m_buttonBox->addButton(QDialogButtonBox::Ok)),
    m_cancelButton(m_buttonBox->addButton(QDialogButtonBox::Cancel))
{
    this->setWindowTitle(tr("Check URLs"));
    this->setAttribute(Qt::WA_DeleteOnClose, false);
    this->setMinimumSize(600, 400);

    m_view->setHeaderLabels(QStringList() << tr("URL") << tr("OK?"));
    m_view->setColumnWidth(0, 520);
    m_view->setColumnWidth(1, 50);
    m_view->setRootIsDecorated(false);
    m_view->setSelectionMode(QTreeWidget::NoSelection);

    m_progressBar->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Preferred);
    m_progressBar->setValue(0);
    m_progressBar->setMaximum(0);

    QGridLayout *grid = new QGridLayout(this);
    grid->addWidget(m_view, 0, 0);
    grid->addWidget(m_progressBar, 1, 0);
    grid->addWidget(m_infoLabel, 2, 0);
    grid->addWidget(m_buttonBox, 3, 0);

    this->connect(m_session->urlChecker(), SIGNAL(urlsQueued(QList<QUrl>)), this, SLOT(checkUrls(QList<QUrl>)));
    this->connect(m_session->urlChecker(), SIGNAL(urlsQueued(QStringList)), this, SLOT(checkUrls(QStringList)));
    this->connect(m_session->urlChecker(), SIGNAL(urlChecked(bool,QUrl,QString,QString,bool)), this, SLOT(onUrlChecked(bool,QUrl,QString,QString,bool)));
    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    this->connect(m_buttonBox, SIGNAL(rejected()), m_session->urlChecker(), SLOT(cancelUrlChecks()));
}

void CheckUrlsDialog::hideEvent(QHideEvent *event) {
    Q_UNUSED(event);

    this->resetDialog();
}

void CheckUrlsDialog::checkUrls(QList<QUrl> urls) {
    m_okButton->setEnabled(false);
    m_cancelButton->setEnabled(true);

    if (m_progressBar->value() == m_progressBar->maximum()) {
        m_progressBar->setValue(0);
        m_progressBar->setMaximum(urls.size());
    }
    else {
        m_progressBar->setMaximum(m_progressBar->maximum() + urls.size());
    }

    for (int i = 0; i < urls.size(); i++) {
        QTreeWidgetItem *item = new QTreeWidgetItem(m_view);
        item->setText(0, urls.at(i).toString());
    }

    m_view->setCurrentItem(m_view->itemAt(0, 0));

    this->show();
}

void CheckUrlsDialog::checkUrls(QStringList urls) {
    m_okButton->setEnabled(false);
    m_cancelButton->setEnabled(true);

    if (m_progressBar->value() == m_progressBar->maximum()) {
        m_progressBar->setValue(0);
        m_progressBar->setMaximum(urls.size());
    }
    else {
        m_progressBar->setMaximum(m_progressBar->maximum() + urls.size());
    }

    for (int i = 0; i < urls.size(); i++) {
        QTreeWidgetItem *item = new QTreeWidgetItem(m_view);
        item->setText(0, urls.at(i));
    }

    m_view->setCurrentItem(m_view->itemAt(0, 0));

    this->show();
}

void CheckUrlsDialog::onUrlChecked(bool ok, const QUrl &url, const QString &service, const QString &fileName, bool done) {
    Q_UNUSED(url);
    Q_UNUSED(service);
    Q_UNUSED(fileName);

    if ((!this->isVisible()) || (!done)) {
        return;
    }

    if (m_view->currentItem()) {
        m_view->currentItem()->setIcon(1, ok ? QIcon::fromTheme("dialog-ok-apply") : QIcon::fromTheme("dialog-close"));
        m_view->setCurrentItem(m_view->itemBelow(m_view->currentItem()));
    }

    m_progressBar->setValue(m_progressBar->value() + 1);

    if (m_progressBar->value() == m_progressBar->maximum()) {
        m_okButton->setEnabled(true);
        m_cancelButton->setEnabled(false);
        m_infoLabel->setText(QString("<i>%1</i>").arg(m_session->urlChecker()->urlChecksCancelled() ? tr("Cancelled") : tr("Completed")));
    }
}

void CheckUrlsDialog::resetDialog() {
    m_progressBar->setValue(0);
    m_progressBar->setMaximum(0);
    m_infoLabel->setText(QString("<i>%1</i>").arg(tr("Checking URLs")));
    m_view->clear();
}
