import QtQuick 1.1
import com.nokia.symbian 1.1

Window {
    id: window

    property alias captchaImage: image.source
    property int timeOut: 0

    signal gotCaptchaResponse(string response)
    signal rejected

    StatusBar {
        id: statusBar

        anchors {
            left: parent.left
            right: parent.right
            top: parent.top
        }
    }

    MySheet {
        id: sheet

        anchors {
            left: parent.left
            right: parent.right
            top: statusBar.bottom
            bottom: parent.bottom
        }

        rejectButtonText: qsTr("Cancel")
        acceptButtonText: textField.text == "" ? "" : qsTr("Done")
        content: Item {
            id: contentItem

            anchors.fill: parent
            clip: true

            Flickable {
                id: flicker

                anchors {
                    fill: parent
                    leftMargin: 10
                    rightMargin: 10
                    topMargin: 10
                }

                contentHeight: column.height

                Column {
                    id: column

                    anchors {
                        top: parent.top
                        left: parent.left
                        right: parent.right
                    }

                    Label {
                        width: parent.width
                        font.bold: true
                        text: qsTr("Please complete captcha")
                        horizontalAlignment: Text.AlignHCenter
                    }

                    Image {
                        id: image

                        x: Math.floor((parent.width / 2) - 200)
                        width: 400
                        height: 200
                        smooth: true
                        fillMode: Image.PreserveAspectFit
                    }

                    Label {
                        x: Math.floor((parent.width / 2) - 200)
                        text: Utils.durationFromSecs(window.timeOut)
                        color: window.timeOut < 10 ? "red" : "white"
                    }

                    TextField {
                        id: textField

                        x: Math.floor((parent.width / 2) - 200)
                        width: 400
                        inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase
                        Keys.onEnterPressed: sheet.accept()
                        Keys.onReturnPressed: sheet.accept()
                    }
                }
            }

            ScrollDecorator {
                flickableItem: flicker
            }
        }

        onAccepted: window.gotCaptchaResponse(textField.text)
        onRejected: window.rejected()
    }

    Timer {
        id: timer

        running: window.timeOut > 0
        repeat: true
        interval: 1000
        onTriggered: window.timeOut--
    }

    onTimeOutChanged: if (window.timeOut <= 0) sheet.reject();

    Component.onCompleted: sheet.open()
}
