import QtQuick 1.1
import com.nokia.symbian 1.1

QueryDialog {
    id: root

    height: contentItem.height
    titleText: "QDL " + Utils.versionNumber
    icon: "qrc:/qdlsymbian48.png"
    onClickedOutside: reject()
    content: Item {
        id: contentItem

        height: column.height + 90
        anchors {
            top: parent.top
            left: parent.left
            right: parent.right
            margins: platformStyle.paddingLarge
        }

        Column {
            id: column

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
            }
            spacing: 20

            Label {
                width: parent.width
                wrapMode: Text.WordWrap
                text: qsTr("A user-friendly download manager.<br><br>&copy; Stuart Howarth 2012-2013")
            }

            Label {
                width: parent.width
                wrapMode: Text.WordWrap
                color: mouseArea.pressed ? Qt.lighter("#4d8ecc") : "#4d8ecc"
                text: qsTr("View privacy policy")

                MouseArea {
                    id: mouseArea

                    anchors.fill: parent
                    onClicked: {
                        showPrivacyPolicy();
                        root.accept();
                    }
                }
            }

            LinkLabel {
                width: parent.width
                text: "<font color ='white'>" + qsTr("Contact") + ": </font><u>stuhowarth77@gmail.com</u>"
                link: "mailto:stuhowarth77@gmail.com?subject=QDL for Symbian"
                onClicked: root.accept()
            }
        }
    }
}
