#ifndef YOUTUBE_H
#define YOUTUBE_H

#include <QObject>
#include <QList>
#include <QUrl>
#include "serviceplugin.h"

class YouTube : public ServicePlugin
{
    Q_OBJECT
    Q_INTERFACES(ServiceInterface)

public:
    explicit YouTube(QObject *parent = 0);
    ServicePlugin* createServicePlugin() { return new YouTube; }
    inline QString iconName() const { return QString("youtube.jpg"); }
    inline QString serviceName() const { return QString("YouTube"); }
    QRegExp urlPattern() const;
    bool urlSupported(const QUrl &url) const;
    void checkUrl(const QUrl &url);
    void getDownloadUrl(const QUrl &url);
    inline bool loginSupported() const { return false; }
    inline bool recaptchaRequired() const { return false; }

private:
    void checkPlaylistVideoUrls(const QUrl &url);

private slots:
    void checkUrlIsValid();
    void parseVideoPage();
    
private:
    QList<int> m_formatList;
};

#endif // YOUTUBE_H
