#ifndef RAPIDSHARE_H
#define RAPIDSHARE_H

#include <QObject>
#include <QUrl>
#include "serviceplugin.h"

class QTimer;

class RapidShare : public ServicePlugin
{
    Q_OBJECT
    Q_INTERFACES(ServiceInterface)

public:
    explicit RapidShare(QObject *parent = 0);
    ServicePlugin* createServicePlugin() { return new RapidShare; }
    inline QString iconName() const { return QString("rapidshare.jpg"); }
    inline QString serviceName() const { return QString("RapidShare"); }
    QRegExp urlPattern() const;
    bool urlSupported(const QUrl &url) const;
    void checkUrl(const QUrl &url);
    void getDownloadUrl(const QUrl &url);
    inline bool loginSupported() const { return true; }
    void login(const QString &username, const QString &password);
    inline bool recaptchaRequired() const { return false; }

private:
    void startWait(int msecs);
    void constructDownloadUrl(const QString &url);

private slots:
    void checkLogin();
    void checkUrlIsValid();
    void checkRedirect();
    void updateWaitTime();
    void onWaitFinished();

private:
    QTimer *m_waitTimer;
    int m_waitTime;
};

#endif // RAPIDSHARE_H
