#ifndef QDESKTOPDIALER_H
#define QDESKTOPDIALER_H

#include <QWidget>
#include <QLineEdit>
#include "contact.h"

class QDesktopDialer : public QWidget
{
Q_OBJECT
public:
    explicit QDesktopDialer(QWidget *parent = 0);

    void setupDesktop();
    void setupSettingsDialog();
    bool x11Event ( XEvent * event );
    void readSettings();
public slots:
    void writeSettings();
    void onNumberPressed(int number);
    void onNumberDoublePressed(int number);
private:
    QLineEdit *lneUserName;
    QLineEdit *lnePassword;
    QLineEdit *lneUrl;
    QLineEdit *lnePollTime;
    QList<Contact> contacts;
signals:

public slots:

};

#endif // QDESKTOPDIALER_H
