#ifndef QNUMBERBUTTON_H
#define QNUMBERBUTTON_H

#include <QPushButton>
#include <QSignalMapper>

class QNumberButton : public QPushButton
{
Q_OBJECT
public:
    explicit QNumberButton(QWidget *parent = 0, int number = 0);

signals:
    void numberPressed(int number);
    void numberDoublePressed(int number);
protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseDoubleClickEvent ( QMouseEvent * event );
public slots:
    void onNumberPressed();
    void onNumberDoublePressed();
private:
    int number;
    QSignalMapper *signalMapper;
    QTimer *timer;
};

#endif // QNUMBERBUTTON_H
