#include "qnumberbutton.h"
#include <QtGui>


QNumberButton::QNumberButton(QWidget *parent, int number) :   QPushButton(parent)
{
    this->number = number;
    //setText(QString::number(number));
    //signalMapper = new QSignalMapper(this);
    //connect(this, SIGNAL(pressed()), this, SLOT(onNumberPressed()));
    //connect(this, SIGNAL(pressed()), signalMapper, SLOT(map()));
    //signalMapper->setMapping(this, this->number);
    //connect(signalMapper, SIGNAL(mapped(int)), parent, SLOT(numberPressed(int)));
}

void QNumberButton::onNumberPressed() {
    emit numberPressed(number);
    qDebug() << "single click";
    timer->stop();
}

void QNumberButton::onNumberDoublePressed() {
    emit numberDoublePressed(number);
}

void QNumberButton::mousePressEvent(QMouseEvent *event) {
    //qDebug() << event->button();
    timer = new QTimer(this);
    timer->start(QApplication::doubleClickInterval() + 50);
    //timer->singleShot(QApplication::doubleClickInterval() + 50);
    //event->ignore();
    connect(timer, SIGNAL(timeout()), this, SLOT(onNumberPressed()));
    event->ignore();
    //emit pressed();
}

void QNumberButton::mouseDoubleClickEvent ( QMouseEvent * event ) {
    timer->stop();
    onNumberDoublePressed();
    //qDebug() << event;
    qDebug() << "double click";
    event->isAccepted();
}
