#include "qdesktopdialer.h"

#include <QtGui>
#include <QtDebug>

#include <QX11Info>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/Xatom.h>

#include "qnumberbutton.h"
#include "phonecall.h"
#include "contact.h"

QDesktopDialer::QDesktopDialer(QWidget *parent) :
    QWidget(parent)
{
    setupDesktop();
    readSettings();
    QGridLayout *layout = new QGridLayout();
    QNumberButton *number1 = new QNumberButton(this, 1);
    number1->show();
    layout->addWidget(number1, 0, 0);
    QNumberButton *number2 = new QNumberButton(this, 2);
    number2->show();
    layout->addWidget(number2, 1, 0);
    QNumberButton *number3 = new QNumberButton(this, 3);
    number3->show();
    layout->addWidget(number3, 0, 1);
    QNumberButton *number4 = new QNumberButton(this, 4);
    number4->show();
    layout->addWidget(number4, 1, 1);
    setLayout(layout);
    number1->setText(contacts[0].name());
    number2->setText(contacts[1].name());
    number3->setText(contacts[2].name());
    number4->setText(contacts[3].name());
    connect(number1, SIGNAL(numberPressed(int)), this, SLOT(onNumberPressed(int)));
    connect(number2, SIGNAL(numberPressed(int)), this, SLOT(onNumberPressed(int)));
    connect(number3, SIGNAL(numberPressed(int)), this, SLOT(onNumberPressed(int)));
    connect(number4, SIGNAL(numberPressed(int)), this, SLOT(onNumberPressed(int)));
    connect(number1, SIGNAL(numberDoublePressed(int)), this, SLOT(onNumberDoublePressed(int)));
    connect(number2, SIGNAL(numberDoublePressed(int)), this, SLOT(onNumberDoublePressed(int)));
    connect(number3, SIGNAL(numberDoublePressed(int)), this, SLOT(onNumberDoublePressed(int)));
    connect(number4, SIGNAL(numberDoublePressed(int)), this, SLOT(onNumberDoublePressed(int)));
}

void QDesktopDialer::onNumberPressed(int number) {
    PhoneCall::Call(contacts[number - 1].phoneNumber());
}

void QDesktopDialer::onNumberDoublePressed(int number) {
    PhoneCall::SendSMS(contacts[number - 1].phoneNumber());
}

void QDesktopDialer::setupDesktop() {
    //setAttribute(Qt::WA_TranslucentBackground);
    setAttribute(Qt::WA_X11NetWmWindowTypeDialog);

    setWindowFlags(windowFlags() | Qt::Dialog);
    //        setAttribute(Qt::WA_Maemo5DesktopApplet);

    Atom window_type = XInternAtom (QX11Info::display(), "_NET_WM_WINDOW_TYPE", False);
    Atom hildonwinType = XInternAtom (QX11Info::display(), "_HILDON_WM_WINDOW_TYPE_HOME_APPLET", False);
    XChangeProperty(QX11Info::display(), winId(), window_type, XA_ATOM, 32,
                    PropModeReplace, (unsigned char *) &hildonwinType, 1);

    Atom appletId = XInternAtom(QX11Info::display(), "_HILDON_APPLET_ID", False);
    Atom utf8String = XInternAtom(QX11Info::display(), "UTF8_STRING", False);
    char appletIdStr[] = "PLASMA_APPLET_THING";
    XChangeProperty(QX11Info::display(), winId(), appletId, utf8String, 8,
                    PropModeReplace, (unsigned char*)appletIdStr, strlen(appletIdStr));

    // the following adds a configure button to the widget, which will be send by some X event...
    Atom hildonAppletSettings = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SETTINGS", False);
    int value = 1;
    XChangeProperty(QX11Info::display(), winId(), hildonAppletSettings, XA_CARDINAL, 32,
                    PropModeReplace, (unsigned char*)&value, 1);

}

void QDesktopDialer::setupSettingsDialog() {
    QDialog *settings = new QDialog(this);
    QVBoxLayout *settingsLayout = new QVBoxLayout();
    settings->setLayout(settingsLayout);
//    lneUserName = new QLineEdit();
//    lneUserName->setText(userName);
//    lneUserName->setPlaceholderText(tr("Your Google Reader username"));
//    settingsLayout->addWidget(lneUserName);
//    lneUserName->show();
//    lnePassword = new QLineEdit();
//    lnePassword->setText(password);
//    lnePassword->setPlaceholderText(tr("Your Google Reader password"));
//    settingsLayout->addWidget(lnePassword);
//    lnePassword->setEchoMode(QLineEdit::PasswordEchoOnEdit);
//    lnePassword->show();
//    lneUrl = new QLineEdit();
//    lneUrl->setText(openUrl);
//    lneUrl->setPlaceholderText(tr("Url to open your Google Reader account"));
//    settingsLayout->addWidget(lneUrl);
//    lneUrl->show();
//    lnePollTime = new QLineEdit();
//    lnePollTime->setText(QString::number(pollInMinutes));
//    lnePollTime->setPlaceholderText(tr("Poll interval in minutes"));
//    settingsLayout->addWidget(lnePollTime);
//    lnePollTime->show();
//    settings->show();
//    connect(settings, SIGNAL(rejected()), this, SLOT(writeSettings()));
}

void QDesktopDialer::writeSettings() {
//    userName = lneUserName->text();
//    password = lnePassword->text();
//    openUrl = lneUrl->text();
//    pollInMinutes = lnePollTime->text().toInt();
//
//    QSettings settings("greader", "greader");
//    settings.setValue("username", userName);
//    settings.setValue("password", password);
//    settings.setValue("openUrl", openUrl);
//    settings.setValue("polltime", pollInMinutes);

}

void QDesktopDialer::readSettings() {
    QSettings settings("Qdialer", "qdialer");
    int size = settings.beginReadArray("contacts");
    for (int i = 0; i < size; ++i) {
       settings.setArrayIndex(i);
       QString name = settings.value("name").toString();
       QString phoneNumber = settings.value("phoneNumber").toString();
       Contact contact(name, phoneNumber);
       contacts.append(contact);
    }
    settings.endArray();
}

//Filter show setting requests
bool QDesktopDialer::x11Event ( XEvent * event )
{
  static Atom appletShowSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SHOW_SETTINGS", false);

  if (event->xclient.message_type == appletShowSettingAtom ) {

      //QMessageBox::information(0, "Setting Dialog example", "Here your settings", QMessageBox::Ok, QMessageBox::Ok);
      setupSettingsDialog();
      return true;
  }
  return false;
}
