/*
 * QCPUFreq - a simple cpufreq GUI
 * Copyright (C) 2010 Daniel Klaffenbach <danielklaffenbach@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LOADPRESET_H
#define LOADPRESET_H

#include <QDialog>

namespace Ui {
    class LoadPreset;
}

class LoadPreset : public QDialog
{
    Q_OBJECT

public:
    explicit LoadPreset(QWidget *parent = 0);
    ~LoadPreset();

signals:
    void load(QString presetName);

public slots:
    void buttonLoadDefaultPressed();
    void buttonLoadIdealPressed();
    void buttonLoadLvPressed();
    void buttonLoadUlvPressed();
    void buttonLoadXlvPressed();
    void buttonLoadCustomPressed();

private:
    Ui::LoadPreset *ui;
};

#endif // LOADPRESET_H
