/*
 * QCPUFreq - a simple cpufreq GUI
 * Copyright (C) 2010 Daniel Klaffenbach <danielklaffenbach@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SETTINGS_H
#define SETTINGS_H

#include <QDialog>
#include <QSettings>

namespace Ui {
    class Settings;
}

class Settings : public QDialog
{
    Q_OBJECT

public:
    explicit Settings(QWidget *parent = 0);
    ~Settings();
    bool isKernelConfigInstalled();
    bool platformMaemo();
    bool useAdvancedTemperature();
    bool useAutoRotate();
    bool useOverclocking();
    bool usePowerKernel();

public slots:
    void reset();
    void save();
    void showOverclockingWarning();

signals:
    void settingsChanged();

private:
    bool advancedTemperature;
    bool autoRotate;
    bool overclocking;
    bool powerKernel;
    bool kernelConfigInstalled;
    QSettings settings;
    Ui::Settings *ui;
};

#endif // SETTINGS_H
