/*
 * QCPUFreq - a simple cpufreq GUI
 * Copyright (C) 2010 Daniel Klaffenbach <danielklaffenbach@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "loadpreset.h"
#include "ui_loadpreset.h"

LoadPreset::LoadPreset(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::LoadPreset)
{
    ui->setupUi(this);

    connect(ui->loadDefault, SIGNAL(clicked()), this, SLOT(buttonLoadDefaultPressed()));
    connect(ui->loadIdeal, SIGNAL(clicked()), this, SLOT(buttonLoadIdealPressed()));
    connect(ui->loadLV, SIGNAL(clicked()), this, SLOT(buttonLoadLvPressed()));
    connect(ui->loadULV, SIGNAL(clicked()), this, SLOT(buttonLoadUlvPressed()));
    connect(ui->loadXLV, SIGNAL(clicked()), this, SLOT(buttonLoadXlvPressed()));
    connect(ui->loadCustom, SIGNAL(clicked()), this, SLOT(buttonLoadCustomPressed()));

}

LoadPreset::~LoadPreset()
{
    delete ui;
}


/**
  * This slot is called when the loadCustom button was pressed.
  * It emits the "load" signal and hides the dialog.
  *
  * @emits: load("custom")
  */
void LoadPreset::buttonLoadCustomPressed()
{
    emit load("custom");
    hide();
}


/**
  * This slot is called when the loadDefault button was pressed.
  * It emits the "load" signal and hides the dialog.
  *
  * @emits: load("default")
  */
void LoadPreset::buttonLoadDefaultPressed()
{
    emit load("default");
    hide();
}


/**
  * This slot is called when the loadIdeal button was pressed.
  * It emits the "load" signal and hides the dialog.
  *
  * @emits: load("ideal")
  */
void LoadPreset::buttonLoadIdealPressed()
{
    emit load("ideal");
    hide();
}


/**
  * This slot is called when the loadLV button was pressed.
  * It emits the "load" signal and hides the dialog.
  *
  * @emits: load("lv")
  */
void LoadPreset::buttonLoadLvPressed()
{
    emit load("lv");
    hide();
}


/**
  * This slot is called when the loadULV button was pressed.
  * It emits the "load" signal and hides the dialog.
  *
  * @emits: load("ulv")
  */
void LoadPreset::buttonLoadUlvPressed()
{
    emit load("ulv");
    hide();
}


/**
  * This slot is called when the loadXLV button was pressed.
  * It emits the "load" signal and hides the dialog.
  *
  * @emits: load("xlv")
  */
void LoadPreset::buttonLoadXlvPressed()
{
    emit load("xlv");
    hide();
}
