/*
 * QCPUFreq - a simple cpufreq GUI
 * Copyright (C) 2010 Daniel Klaffenbach <daniel.klaffenbach@cs.tu-chemnitz.de>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QGraphicsScene>
#include <QTimer>
#include <QProcess>
#include <QStringList>

#include "helpwindow.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

public slots:
    void about();
    void adjustFreq();
    void orientationChanged();
    void refresh();
    void setAutoRotation();
    void setOverclocking();
    void setSmartReflex();
    void showHelp();


private:
    Ui::MainWindow *ui;
    bool allowOverclocking;
    int callHelper( QString action, QString param );
    QString getCPUTemp();
    int getMaxFreq();
    int getMinFreq();
    int getScalingFreq( int step );
    QString getScalingGovernor();
    int getScalingStep( int freq );
    int getScalingSteps();
    int getSmartReflexState();
    //! The helper process
    QProcess helperProcess;
    //! The help window
    HelpWindow helpWindow;
    //! Initializes the application
    void init();
    int minFreq;
    //! Are we using a power kernel?
    bool powerKernel;
    QString readSysFile( QString sys_file );
    //! the timer for refreshing the UI
    QTimer refreshTimer;
    //! The amount of scaling steps
    int scalingSteps;
    //! The available scaling frequencies
    QStringList scalingFrequencies;
    //! the QGraphicsScene will contain the large chip icon displayed in the UI
    QGraphicsScene scene;
    bool showSudoError;
    bool usePortrait();
};

#endif // MAINWINDOW_H
