#include "helpwindow.h"
#include "ui_helpwindow.h"

#include <QFile>
#include <QLocale>
#include <QTextStream>
#include <QMessageBox>
#include <QPalette>
#include <QBrush>
#include <QColor>

HelpWindow::HelpWindow(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::HelpWindow)
{
    //this is a stacked window on Maemo 5
    #if defined(Q_WS_MAEMO_5)
	//setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif
    ui->setupUi(this);

    setHelpText();

    //format color of help text according to system color scheme
    QPalette palette;
    QBrush brush = palette.windowText();
    QColor color = brush.color();
    ui->textBrowser->setStyleSheet( "QTextEdit {background: transparent; color: " + color.name() + ";}" );
}


HelpWindow::~HelpWindow()
{
    delete ui;
}


/**
  * Assigns the help text to the QTextEdit
  */
void HelpWindow::setHelpText()
{
    //get the current locale name for lacalized help messages
    QString locale = QLocale::system().name();
    QStringList tmp = locale.split("_");
    locale = tmp.first();

    //open help text
    QFile help( ":/txt/help_" + locale );

    //open the file
    if ( !help.exists() || !help.open( QIODevice::ReadOnly ) ) {
	//try to open the file in english language instead
	help.setFileName(":/txt/help_en");
	if ( !help.exists() || !help.open( QIODevice::ReadOnly ) ) {
	    QMessageBox::critical(this, tr("QCPUFreq"), tr("Cannot open help file!"));
	    return;
	}
    }

    //read the file
    QTextStream in( &help );
    QString txt;
    do {
	txt += in.readLine();
	txt += "\n";
    } while ( !in.atEnd() );

    ui->textBrowser->setText( txt );
}
