#include "ball.h"
#include <QUuid>
#include <QBrush>
#include <QPen>
#include <QDebug>
const int Ball::LEFT = 0;
const int Ball::RIGHT = 630;
const int Ball::TOP = 10;
const int Ball::BOTTOM = 307;
const int Ball::MAX_SIZE_EXPLOTION = 45;
const int Ball::TIME_MAX_EXPLOTION= 45;


Ball::Ball(const QLineF &directionLine, QGraphicsItem *parent) :
        QGraphicsEllipseItem(parent),
        direction(1,0),
        mode(MODE_NORMAL),
        animationState(STATE_EXPAND),
        animationWaiting(0),
        ballSize(25)
{
    if ( QLineF() != directionLine ) {
      direction.setX(-(directionLine.dx() / RIGHT) * 10);
      direction.setY(-(directionLine.dy() / BOTTOM) * 10);
      qDebug()<<direction;
    } else {
      initDirection();
    }
    initPosition();
    setRect(-ballSize / 2,-ballSize / 2,ballSize,ballSize);
    qsrand((uint)this);
    setPen(QPen(Qt::NoPen));
    QBrush brush;
    color = QColor(qrand()%256,qrand()%256,qrand()%256);
    brush.setColor(color);
    brush.setStyle(Qt::SolidPattern);
    setBrush(brush);
}

bool Ball::update() {
    if (MODE_NORMAL == mode) {
        borderControl();
        moveBy(direction.x(),direction.y() );
    } else {
        setRotation(rotation() + 3);
        switch (animationState) {
            case STATE_EXPAND:
                setOpacity(opacity() / 1.02f);
                if (ballSize < MAX_SIZE_EXPLOTION) {
                    ++ballSize;
                    setScale(scale()+0.1f);
                } else {
                    animationState = STATE_WAITING;
                }
            break;
            case STATE_WAITING:
                if (animationWaiting < TIME_MAX_EXPLOTION) {
                    ++animationWaiting;
                } else {
                    animationState = STATE_DECREASE;
                }
            break;
            case STATE_DECREASE:
                if (ballSize > 0) {
                    setOpacity(opacity() / 1.01f);
                    --ballSize;
                    if (scale() > 0)
                      setScale(scale()-0.1f);
                }
                else
                    return false;
            break;
        }
    }
    return true;
}

void Ball::initDirection() {

    direction.setX( (qreal)((qrand()%100) +1) / 100);
    direction.setY( (qreal)((qrand()%100) +1) / 100);
    qDebug()<<"Init Direction"<<direction;
}

void Ball::initPosition() {
    setPos((qrand()%RIGHT) +1 , (qrand()%BOTTOM) +1);
    qDebug()<<"Init Position"<<pos();
}

void Ball::borderControl() {
    if ((pos().x() < LEFT) || (pos().x() > RIGHT )) {
     direction.setX(-direction.x());
    }
    if ((pos().y() < TOP) || (pos().y() > BOTTOM )) {
     direction.setY(-direction.y());
    }
}


void Ball::collisionDetected() {
    mode = MODE_EXPLOSION;
    QBrush brush;
    setOpacity(0.9f);
    brush.setColor(color);
    brush.setStyle(Qt::Dense6Pattern);
    setBrush(brush);
}

