import QtQuick 1.0
//import com.nokia.meego 1.0

Rectangle {
    id: mainCalcResult
    anchors.top: parent.top
    anchors.left: parent.left
    anchors.right: parent.right
    color: _BACKGROUND_COLOR

    Connections {
        target: CalcServer
        onFinished: {
            inputZone.clearText()
            var resV = CalcServer.getLastResStr()
            var calcS = CalcServer.getLiteral()
            resultModel.append( {"memLabel": "res" + memIndex, "resValue": resV, "calcString": calcS} )
            memIndex = memIndex + 1
            resulListView.positionViewAtEnd()
        }
    }

    ListModel {
        id: resultModel
        /*ListElement {
            memLabel: "res0"
            resValue: 0.0
            calcString: "ln(1)"
        }*/
    }
    Component {
        id: resultDelegate
        Rectangle {
            height: _ROW_SIZE
            width: mainCalcResult.width
            border.width: _BORDER_SIZE
            radius:_RECTANGLE_RADIUS
            color: _BACKGROUND_COLOR
            border.color: _BORDER_COLOR
            Text {
                anchors.top: parent.top
                anchors.left: parent.left
                anchors.right: parent.right
                id: calculatedString
                text: calcString + " ="
                font.pixelSize: _SMALL_FONT_SIZE
                color: _TEXT_COLOR
            }
            Text {
                anchors.top: calculatedString.bottom
                anchors.left: parent.left
                anchors.bottom: parent.bottom
                text: memLabel + ":"
                font.pixelSize: _SMALL_FONT_SIZE
                color: _TEXT_COLOR
            }
            Text {
                anchors.top: calculatedString.bottom
                anchors.right: parent.right
                anchors.bottom: parent.bottom
                text: resValue
                clip: true
                font.weight: Font.Bold
                font.pixelSize: _SMALL_FONT_SIZE
                color: _TEXT_COLOR
            }
        }
    }
    ListView {
        id: resulListView
        anchors.fill: parent
        model: resultModel
        delegate: resultDelegate
    }

}

