import QtQuick 1.0
//import com.nokia.meego 1.0

Rectangle {
    width: 2 * _BUTTON_SIZE
    height: 4 * _BUTTON_SIZE
    color: _BACKGROUND_COLOR

    anchors.right: parent.right
    anchors.bottom: parent.bottom

    Grid {
        columns: 2
        rows: 4
        CalcButton{
            text: "/"
            fnText: ""
            onButtonClick: {
                if (isFnState) {
                    inputZone.addText("res")
                    isFnState = false
                }
                else
                    inputZone.addText(text)
            }
        }
        CalcButton{
            text: "BkSp"
            fnText: "Clr"
            onButtonClick: {
                if (isFnState) {
                    inputZone.clearText()
                    isFnState = false
                }
                else
                    inputZone.bkSpaceText()
            }
        }

        CalcButton{
            text: "x"
            fnText: "("
            onButtonClick: {
                if (isFnState) {
                    inputZone.addText(fnText)
                    isFnState = false
                }
                else
                    inputZone.addText("*");
            }
        }
        CalcButton{
            text: "( )"
            fnText: ")"
            onButtonClick: {
                if (isFnState) {
                    inputZone.addText(fnText)
                    isFnState = false
                }
                else {
                    inputZone.addText("()");
                    inputZone.moveCursor(true)
                }
            }
        }

        CalcButton{
            text: "-"
            fnText: "^V"
            onButtonClick: {
                if (isFnState) {
                    inputZone.textEdit.paste()
                    isFnState = false
                }
                else
                    inputZone.addText(text);
            }
        }
        CalcButton{
            text: "->"
            fnText: "<-"
            onButtonClick: {
                if (isFnState) {
                    inputZone.moveCursor(true)
                    isFnState = false
                }
                else
                    inputZone.moveCursor(false)
            }
        }

        CalcButton{
            text: "+"
            fnText: "^C"
            onButtonClick: {
                if (isFnState) {
                    CalcServer.lastResStrToClipboard();
                    isFnState = false
                }
                else
                    inputZone.addText(text);
            }
        }
        CalcButton{
            text: "="
            fnText: "res"
            onButtonClick: {
                if (isFnState) {
                    inputZone.addText(fnText)
                    isFnState = false
                }
                else {
                    CalcServer.parse(inputZone.text, "res" + memIndex);
                }
            }
        }
    }
}
