#ifndef OPERAND_MULTIPLICATION_H
#define OPERAND_MULTIPLICATION_H

#include "../operand.h"
#include "vector"

namespace QalcuLib
{
    class Multiplication : public Operand
    {
    public:
        Multiplication( const std::vector<OperandPtr> &operands,
                        const std::vector<bool> &isMultiplicative);

        virtual double compute();

    private:
        Multiplication();

    protected:
        std::vector<OperandPtr> m_operands;
        std::vector<bool>       m_isMultiplicative;
    };
}

#endif // OPERAND_MULTIPLICATION_H
