#ifndef OPERAND_FUNCTION_H
#define OPERAND_FUNCTION_H

#include "../operand.h"
#include "QString"

namespace QalcuLib
{
    class Function : public Operand
    {
    public:
        Function(const OperandPtr &value, const QString &function);

        virtual double compute();

        enum EFunction{
            eSqrt,
            eLn,
            eLog,
            eExp,
            eCos,
            eSin,
            eTan
        };

    private:
        Function();

    protected:
        void checkPositive( double value ) const;
        void checkDefinitePositive( double value ) const;

        OperandPtr  m_value;
        EFunction   m_function;
        QString     m_functionString;
    };


}

#endif // OPERAND_FUNCTION_H
