#include "operand.h"
#include "operands/number.h"
#include <exception>
using namespace QalcuLib;
using namespace std;

Operand::Operand()
{
}

Complex Operand::computeComplex()
{
    throw std::exception(); //"One operand does not support complex calculation!");
}

OperandDictionary::OperandDictionary()
{
    pair<QString,OperandPtr> temp;
    temp.first = "pi";
    temp.second = OperandPtr( new Number(3.14159265358979323846264338327950288419716939937510) );
    m_ConstantDictionary.insert(temp);
    temp.first = "e";
    temp.second = OperandPtr( new Number(2.71828182845904523536028747135266249775724709369995) );
    m_ConstantDictionary.insert(temp);
}

OperandPtr OperandDictionary::getOperand(const QString &key)
{
    map<QString,OperandPtr>::const_iterator it;

    QString lowKey = key.toLower();
    it = m_ConstantDictionary.find(lowKey);
    if (it != m_ConstantDictionary.end())
        return it->second;

    it = m_MemoryDictionary.find(lowKey);
    if (it != m_MemoryDictionary.end())
        return it->second;

    QString error = key + " not found";
    throw exception();
}

void OperandDictionary::addOperand(const QString &key, const OperandPtr &value)
{
    QString lowKey = key.toLower();
    pair<QString,OperandPtr> newItem;
    newItem.first = lowKey;
    newItem.second = value;
    m_MemoryDictionary.insert(newItem);
}


QStringList OperandDictionary::getMemoryKeys() const
{
    map<QString,OperandPtr>::const_iterator it = m_MemoryDictionary.begin();
    QStringList res;
    for(;it != m_MemoryDictionary.end(); it++)
        res << it->first;
    return res;
}

QStringList OperandDictionary::getConstantKeys() const
{
    map<QString,OperandPtr>::const_iterator it = m_ConstantDictionary.begin();
    QStringList res;
    for(;it != m_ConstantDictionary.end(); it++)
        res << it->first;
    return res;
}

