#include "operatorsfactory.h"
#include "../operandfactory.h"
#include "../operands/power.h"
#include "../operands/multiplication.h"
#include "../operands/addition.h"
#include <list>
#include <vector>

using namespace QalcuLib;
using namespace std;

strPower::strPower(const QString &expression)
    :m_isEmpty(true)
{
    QString::ConstIterator strIt = expression.begin();
    qint32 nbPar(0);
    qint32 nbPow(0);
    size_t index(0);
    for (; strIt != expression.end(); strIt++, index++)
    {
        if (*strIt == 40) // (
            nbPar++;
        else if (*strIt == 41) // )
        {
            nbPar--;
            if (nbPar < 0)
                throw exception(); //"Too many )!");
        }
        else if (nbPar == 0 && *strIt == 94) //^
        {
            if (nbPow > 0)
                throw exception();//"Found two power at the same level (ambiguous)");
            nbPow++;
            m_isEmpty = false;
            m_first.append(expression.midRef(0,index));
            m_second.append(expression.midRef(index+1,-1));
        }

    }
    if (m_isEmpty)
        m_first = expression;
}

OperandPtr strPower::makeOperand(OperandDictionaryPtr dic)
{
    if (m_isEmpty)
        return endFactory(m_first, dic);
    else
    {
        OperandPtr value = mainFactory(m_first, dic);
        OperandPtr exponent = mainFactory(m_second, dic);
        OperandPtr res(new Power(value, exponent));
        return res;
    }
}

strMultiplication::strMultiplication(const QString &expression)
    :m_isEmpty(true)
{
    QString::ConstIterator strIt = expression.begin();
    QString couple;
    QRegExp impliedMult("^[)0-9][a-z]$",Qt::CaseInsensitive);
    QRegExp impliedParMult("^[)0-9][(]$",Qt::CaseInsensitive);
    qint32 nbPar(0);
    size_t prevIdx(0), index(0);
    bool isPrevMult(true);
    for (; strIt != expression.end(); strIt++, index++)
    {
        if (*strIt == 40) //(
            nbPar++;
        else if (*strIt == 41) //)
        {
            nbPar--;
            if (nbPar < 0)
                throw exception();//"Too many )!");
        }
        else if (nbPar == 0 && (*strIt == 42 || *strIt == 47))// * /
        {
            m_isEmpty = false;
            QString tempStr;
            tempStr.append(expression.midRef(prevIdx,index-prevIdx));
            strPowerPtr tempPow(new strPower(tempStr));
            m_members.push_back(tempPow);
            prevIdx = index + 1;
            m_isMult.push_back(isPrevMult);
            if (*strIt == 47) // /
                isPrevMult = false;
            else
                isPrevMult = true;
        }

        if (index>0)
        {
            couple = expression.mid(index-1,2);
            if ( (nbPar == 0 && couple.contains(impliedMult))
                 || (nbPar == 1 && couple.contains(impliedParMult)) )
            {
                m_isEmpty = false;
                QString tempStr;
                tempStr.append(expression.midRef(prevIdx,index-prevIdx));
                strPowerPtr tempPow(new strPower(tempStr));
                m_members.push_back(tempPow);
                prevIdx = index ;
                m_isMult.push_back(isPrevMult);
                isPrevMult = true;
            }
        }

    }
    if (m_isEmpty)
    {
        strPowerPtr tempPow(new strPower(expression));
        m_members.push_back(tempPow);
    }
    else
    {
        QString tempStr;
        tempStr.append(expression.midRef(prevIdx,-1));
        strPowerPtr tempPow(new strPower(tempStr));
        m_members.push_back(tempPow);
        m_isMult.push_back(isPrevMult);
    }
}

OperandPtr strMultiplication::makeOperand(OperandDictionaryPtr dic)
{

    if (m_isEmpty)
        return (*(m_members.begin()))->makeOperand(dic);
    else
    {
        vector<OperandPtr> members(m_members.size());
        vector<bool> isMult(m_members.size());

        list<strPowerPtr>::iterator powIt = m_members.begin();
        list<bool>::iterator multIt = m_isMult.begin();
        vector<OperandPtr>::iterator membIt = members.begin();
        vector<bool>::iterator multVecIt = isMult.begin();

        for (;powIt != m_members.end(); powIt++, multIt++, membIt++, multVecIt++)
        {
            *multVecIt = *multIt;
            OperandPtr temp = (*powIt)->makeOperand(dic);
            *membIt = temp;
        }
        OperandPtr res(new Multiplication(members, isMult));
        return res;
    }
}



strAddition::strAddition(const QString &expression)
    :m_isEmpty(true)
{
    QString::ConstIterator strIt = expression.begin();
    qint32 nbPar(0);
    size_t prevIdx(0), index(0);
    bool isPrevAdd(true);
    for (; strIt != expression.end(); strIt++, index++)
    {
        if (*strIt == 40) // (
            nbPar++;
        else if (*strIt == 41) // )
        {
            nbPar--;
            if (nbPar < 0)
                throw exception();//"Too many )!");
        }
        else if (nbPar == 0 && (*strIt == 43 || *strIt == 45) && index > 0) // + -
        {
            m_isEmpty = false;
            QString tempStr;
            tempStr.append(expression.midRef(prevIdx,index-prevIdx));
            strMultiplicationPtr tempMult(new strMultiplication(tempStr));
            m_members.push_back(tempMult);
            prevIdx = index + 1;
            m_isAdd.push_back(isPrevAdd);
            if (*strIt == 45) // -
                isPrevAdd = false;
            else
                isPrevAdd = true;
        }

    }
    if (m_isEmpty)
    {
        strMultiplicationPtr tempMult(new strMultiplication(expression));
        m_members.push_back(tempMult);
    }
    else
    {
        QString tempStr;
        tempStr.append(expression.midRef(prevIdx,-1));
        strMultiplicationPtr tempMult(new strMultiplication(tempStr));
        m_members.push_back(tempMult);
        m_isAdd.push_back(isPrevAdd);
    }
}

OperandPtr strAddition::makeOperand(OperandDictionaryPtr dic)
{

    if (m_isEmpty)
        return (*(m_members.begin()))->makeOperand(dic);
    else
    {
        vector<OperandPtr> members(m_members.size());
        vector<bool> isAdd(m_members.size());

        list<strMultiplicationPtr>::iterator multIt = m_members.begin();
        list<bool>::iterator addIt = m_isAdd.begin();
        vector<OperandPtr>::iterator membIt = members.begin();
        vector<bool>::iterator addVecIt = isAdd.begin();

        for (;multIt != m_members.end(); multIt++, addIt++, membIt++, addVecIt++)
        {
            *addVecIt = *addIt;
            OperandPtr temp = (*multIt)->makeOperand(dic);
            *membIt = temp;
        }
        OperandPtr res(new Addition(members, isAdd));
        return res;
    }
}

