#ifndef CALCSERVER_H
#define CALCSERVER_H

#include <QObject>
#include <QString>
#include <QApplication>
#include <QClipboard>
#include "../lib/operandfactory.h"

namespace QalcUI
{
    class CalcServer : public QObject
    {
        Q_OBJECT
    public:
        explicit CalcServer(QObject *parent = 0);

        Q_INVOKABLE double getLastRes() const {
            return m_lastRes;
        }
        Q_INVOKABLE QString getLastResStr() const {
            QString s;
            s.setNum(m_lastRes,'g',6);
            return s;
        }

        Q_INVOKABLE QString getLiteral() const {
            return m_literal;
        }

        Q_INVOKABLE void lastResStrToClipboard() {
            QClipboard *clipboard = QApplication::clipboard();
            QString text = getLastResStr();
            clipboard->setText(text, QClipboard::Clipboard);
            clipboard->setText(text, QClipboard::Selection);
        }

    signals:
        void finished();
        void parsingError();
        void genericError();

    public slots:
        void parse( QString toCalc, QString label);

    protected:
        QString m_literal;
        QalcuLib::OperandPtr m_parsed;
        double m_lastRes;

        QalcuLib::OperandDictionaryPtr m_Dictionary;

    };
}
#endif // CALCSERVER_H
