import QtQuick 1.0

Rectangle {
    id: inputZone
    height: _ROW_SIZE
    //width:100
    color: _INPUT_COLOR
    border.color: _BORDER_COLOR
    border.width: _BORDER_SIZE
    radius:_RECTANGLE_RADIUS

    anchors.margins: 0
    anchors.right: parent.right
    anchors.left: parent.left

    property alias text: inputTextEdit.text
    property alias textEdit: inputTextEdit

    function addText( addedText )
    {
        var pos = inputTextEdit.cursorPosition;
        text = text.slice(0,pos) + addedText + text.slice(pos,text.length)
        inputTextEdit.cursorPosition = pos + addedText.length
    }

    function clearText( )
    {
        text = ""
    }

    function bkSpaceText( )
    {
        var pos = inputTextEdit.cursorPosition;
        if (pos>0)
        {
            text = text.slice(0,pos-1) + text.slice(pos,text.length)
            inputTextEdit.cursorPosition = pos - 1
        }
    }

    function moveCursor( isToLeft )
    {
        var pos = inputTextEdit.cursorPosition;
        if (isToLeft && pos>0)
            inputTextEdit.cursorPosition = pos - 1
        else if (!isToLeft && pos<text.length)
            inputTextEdit.cursorPosition = pos + 1
    }

    TextEdit {
        id: inputTextEdit
        text: ""
        font.pixelSize: _STANDARD_FONT_SIZE
        cursorVisible: true
        selectedTextColor: "#ffffff"
        selectionColor: "#222222"
        z: 1
        //focus: true
        anchors.fill: parent
        horizontalAlignment: TextEdit.AlignLeft
        wrapMode: TextEdit.WrapAnywhere

        Keys.onEnterPressed: {
            //console.log("Enter key pressed");
            event.accepted = true;
            CalcServer.parse(inputTextEdit.text, "res" + memIndex);
        }
        Keys.onReturnPressed: {
            //console.log("Return key pressed");
            event.accepted = true;
            CalcServer.parse(inputTextEdit.text, "res" + memIndex);
        }
        Keys.onEscapePressed: {
            event.accepted = true;
            inputTextEdit.text = "";
        }
    }
}
