import QtQuick 1.0

Item {
    height: _BUTTON_SIZE
    width: _BUTTON_SIZE

    property alias text: label.text
    property alias fnText: fnLabel.text
    property alias fontSize: label.font.pixelSize

    Rectangle {
        id: button
        anchors.fill: parent
        anchors.margins: 0
        border.width: _BORDER_SIZE
        radius:_RECTANGLE_RADIUS
        color: _BACKGROUND_COLOR
        border.color: _BORDER_COLOR
    }

    Text {
        id: label
        anchors.fill: parent
        anchors.margins: 8
        text: "NA"
        color: _TEXT_COLOR
        font.pixelSize: _LARGE_FONT_SIZE
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignBottom
    }

    Text {
        id: fnLabel
        anchors.fill: parent
        anchors.margins: 8
        text: "NA"
        color: _FN_COLOR
        font.pixelSize: _LARGE_FONT_SIZE
        horizontalAlignment: Text.AlignRight
        verticalAlignment: Text.AlignTop
    }


    signal buttonClick()
    onButtonClick: {
        console.log(label.text + " clicked" )
    }

    MouseArea {
        anchors.fill: parent
        onClicked: buttonClick()
        hoverEnabled: true
        onPressed: {
            button.color = _ACTIVATED_COLOR
        }
        onReleased: {
            button.color = _BACKGROUND_COLOR
        }
     }
}

