#include "power.h"
#include "math.h"
using namespace QalcuLib;
using namespace std;

Power::Power(const OperandPtr &value, const OperandPtr &exponent )
    :m_value(value),m_exponent(exponent)
{}

double Power::compute()
{
    double value = m_value->compute();
    double exponent = m_exponent->compute();
    if (value <= 0.0)
        throw exception();//"Cannot compute the power of a negative number");

    return exp(exponent * log(value) );
}
