# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file 'newtask.ui'
#
# Created: Mon Dec 28 12:32:21 2009
#      by: PyQt4 UI code generator 4.6.1
#
# WARNING! All changes made in this file will be lost!

try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui

from config import Config
from person import Person
from qaikuconnection import QaikuConnection, QaikuData, QaikuUser

from ui_ibox import Ui_IBox

class Ui_UserEditor(QtGui.QDialog):
    def __init__(self, person = None):
        QtGui.QDialog.__init__(self)
        # Setup static ui content
        self.setObjectName("UserEditor")
        if person != None:
            Ui_IBox(self, "Couldn't authenticate, retype your password")
            self.setWindowTitle(QtGui.QApplication.translate("UserEditor", "Authenticate", None, QtGui.QApplication.UnicodeUTF8))
        else:
            self.setWindowTitle(QtGui.QApplication.translate("UserEditor", "Edit User Information", None, QtGui.QApplication.UnicodeUTF8))
        # Vertical box layout
        self.layout = QtGui.QGridLayout(self)

        # Username label text
        self.usernameLabel = QtGui.QLabel(QtCore.QString("Your Qaiku username:"))
        self.layout.addWidget(self.usernameLabel, 0, 0)
        # Username input field
        self.usernameEdit = QtGui.QLineEdit(self)
        self.new = True
        if person != None:
            self.usernameEdit.setText(person.getLogin())
            self.usernameEdit.setDisabled(True)
            self.new = False
        else:
            self.usernameEdit.setText("")
        self.layout.addWidget(self.usernameEdit, 0, 1)

        # Password label text
        self.passwordLabel = QtGui.QLabel(QtCore.QString("Your Qaiku password:"))
        self.layout.addWidget(self.passwordLabel, 1, 0)
        # Password input field
        self.passwordEdit = QtGui.QLineEdit(self)
        self.passwordEdit.setEchoMode(QtGui.QLineEdit.Password)
        self.passwordEdit.setText("")
        self.layout.addWidget(self.passwordEdit, 1, 1)

        # URL label text
        self.urlLabel = QtGui.QLabel(QtCore.QString("Site URL:"))
        self.layout.addWidget(self.urlLabel, 2, 0)
        # URL input field
        self.urlEdit = QtGui.QLineEdit(self)
        self.urlEdit.setText(QtCore.QString("www.qaiku.com"))
        #self.urlEdit.setDisabled(True)
        if person != None:
            self.urlEdit.setDisabled(True)
        #self.urlEdit.setEchoMode(QtGui.QLineEdit.Password)
        self.layout.addWidget(self.urlEdit, 2, 1)

        # Ok button
        self.saveButton = QtGui.QPushButton(self)
        self.saveButton.setText(QtCore.QString("Authenticate"))
        self.layout.addWidget(self.saveButton, 3, 1)
        
        # Set auth button as default one
        self.saveButton.setDefault(True)
        
        # Connect to signals
        QtCore.QObject.connect(self.saveButton, QtCore.SIGNAL("clicked()"), self.saveUserData)


    def saveUserData(self):
        # Fetch values and convert from QString => string        
        self.username = str(self.usernameEdit.text())
        self.password = str(self.passwordEdit.text())
        url = str(self.urlEdit.text())
        
        # Validate
        if len(self.username) < 1:
            Ui_IBox(self, "Username has not been set")
            return
        if len(url) < 1:
            Ui_IBox(self, "URL has not been set")
            return
        # Check local db for existing username
        try:
            person = Person(str(self.username))
            if person.active == 1:
                Ui_IBox(self, "Username is already in use")
                return
        except:
            pass
        
        # TODO: Aseta 'odota loginia' banneri
        
        # Authenticate from qaiku
        if Config().sync.setHost(url) != True:
            #Ui_IBox(self, "Invalid URL given")
            #return
            pass
           
        # authFinished is called, when authentication request is ready (success and failure)
        self.saveButton.setDisabled(True)
        person = Config().sync.authenticate(self.username, self.password)
        if isinstance(person, str):
            Ui_IBox(self, person)
            self.saveButton.setDisabled(False)
        else:
            person.active = 1
            person.avatarupdate = 1
            person.server = url
            person.new = 1
            person.update()
            Config().frontpage.addLoginButton(person)
            self.done(1)

