# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui

import time

from config import Config
from message import Message
from person import Person

from ui_ibox import Ui_IBox
from ui_persons import Ui_Persons


class Ui_TaskEditor(QtGui.QDialog):
    def __init__(self):
        QtGui.QDialog.__init__(self)
        self.setObjectName("Ui_Taskeditor")
        self.setWindowTitle(self.tr("New task to project")+" #"+Config().currentChannel.getName())

        self.currentPerson = Config().currentPerson
        
        # main layout
        self.layout = QtGui.QVBoxLayout(self)

        # first row
        layout = QtGui.QHBoxLayout()
        self.layout.addLayout(layout)
        self.buttonUser = QtGui.QPushButton(self)
        self.buttonUser.setIcon(QtGui.QIcon(self.currentPerson.getAvatar()))
        self.buttonUser.setText(self.currentPerson.getScreenName())
        layout.addWidget(self.buttonUser, 100, QtCore.Qt.AlignLeft)
        self.connect(self.buttonUser, QtCore.SIGNAL("clicked()"), self.selectUser)
        
        
        self.buttonCreate = QtGui.QPushButton(self.tr("Create"), self)
        layout.addWidget(self.buttonCreate)
        layout.setStretchFactor(self.buttonCreate, 0)
        self.connect(self.buttonCreate, QtCore.SIGNAL("clicked()"), self.saveTask)
        #spacer = QtGui.QSpacerItem(40, 20, QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        #layout.addItem(spacer)

        #spacer = QtGui.QSpacerItem(20, 40, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        #self.layout.addItem(spacer)
        self.label_3 = QtGui.QLabel(self.tr("Description"), self)
        self.layout.addWidget(self.label_3)

        self.editDescription = QtGui.QLineEdit(self)
        self.layout.addWidget(self.editDescription)
        #spacerItem2 = QtGui.QSpacerItem(20, 40, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        #self.layout.addItem(spacerItem2)
        self.horizontalLayout_2 = QtGui.QHBoxLayout()

        self.layout_4 = QtGui.QVBoxLayout()

        self.labelPriority = QtGui.QLabel(self.tr("Priority"), self)
        self.layout_4.addWidget(self.labelPriority)
        #spacerItem3 = QtGui.QSpacerItem(20, 40, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        #self.layout_4.addItem(spacerItem3)
        self.sliderPriority = QtGui.QSlider(self)
        self.sliderPriority.setOrientation(QtCore.Qt.Horizontal)
        #slider additional settings
        self.sliderPriority.setRange(1, 5);
        self.sliderPriority.setTracking(True)
        self.sliderPriority.setSingleStep(1)
        self.layout_4.addWidget(self.sliderPriority)
        self.connect(self.sliderPriority, QtCore.SIGNAL("valueChanged(int)"), self.updateSlider)
        
        self.horizontalLayout_2.addLayout(self.layout_4)
        #spacerItem4 = QtGui.QSpacerItem(20, 40, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        #self.horizontalLayout_2.addItem(spacerItem4)
        layout = QtGui.QVBoxLayout()
        layout.setContentsMargins(-1, -1, 0, -1)
        self.layout.addLayout(self.horizontalLayout_2)

        self.label_5 = QtGui.QLabel(self.tr("Deadline"), self)

        layout.addWidget(self.label_5)
        #spacerItem5 = QtGui.QSpacerItem(20, 40, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        #layout.addItem(spacerItem5)
        self.dateEdit = QtGui.QDateEdit(self)
        self.dateEdit.setCalendarPopup(True)

        # Date additional
        self.dateEdit.setDate( QtCore.QDate.currentDate() )
        self.dateEdit.setMinimumDate( QtCore.QDate.currentDate() )
        # --
        layout.addWidget(self.dateEdit)
        self.horizontalLayout_2.addLayout(layout)
        #spacerItem6 = QtGui.QSpacerItem(20, 40, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        #self.layout.addItem(spacerItem6)

        #self.setWindowTitle(QtCore.QObject.tr("Add a New Task"))

        self.priorities = { 1: 'Trivial', 2: 'Minor', 3: 'Major', 4: 'Critical', 5: 'Blocker'}
        self.validationError = ""

        #Update priority
        priority = "Priority: %s" % self.priorities[self.sliderPriority.value()]
        self.labelPriority.setText(QtGui.QApplication.translate("Form", priority, None, QtGui.QApplication.UnicodeUTF8))


    def updateSlider(self, slidervalue):
        priority = "Priority: %s" % self.priorities[slidervalue]
        self.labelPriority.setText(self.tr(priority))


    def saveTask(self):
        description = self.editDescription.text()
        deadline = time.mktime(time.strptime(str(self.dateEdit.date().toString("yyyy-MM-dd")), "%Y-%m-%d"))
        priority = self.sliderPriority.value()

        if self.validateInput(description, deadline, priority):
            #create the new task
            task = Message()
            task.language = "fi"
            task.message = str(description)
            task.ownerid = int(self.currentPerson.id)
            task.priority = int(priority)
            task.completeness = 0
            task.deadline = int(deadline)
            task.channelid = Config().currentChannel.id
            task.comment = 0
            task.istask = 1
            task.create()
            # Add a new item to the inteface
            Config().tasklist.addMessage(task)
            #go back to listing
            self.hide()
            Config().sync.enableSection("users", False)
            Config().sync.enableSection("channels", False)
            Config().sync.enableSection("post", True)
            Config().sync.synchronize(False)
        else:
            Ui_IBox(self, self.validationError)


    def selectUser(self):
        dlg = Ui_Persons(self.currentPerson)
        id = dlg.exec_()
        if id > 0:
            self.currentPerson = Person(id)
            self.buttonUser.setIcon(QtGui.QIcon(self.currentPerson.getAvatar()))
            self.buttonUser.setText(self.currentPerson.getScreenName())

        
    def validateInput(self, description, deadline, priority):
        #just check the description

        if len(description) > 0:
            return True
        else:
            self.validationError = self.tr("Description cannot be empty")
            return False
        