# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui

from config import Config
from message import Message
from person import Person

from ui_message import Ui_Message
from ui_message import Ui_Message
from ui_list import Ui_List, Ui_ListWidget
from ui_messageeditor import Ui_MessageEditor


class Ui_MessageView(QtGui.QMainWindow):
    def __init__(self, ui_message, parent = None):
        self.parentUiMessage = ui_message
        self.message = ui_message.message
        if parent == None:
            parent = Config().windowMain
        QtGui.QMainWindow.__init__(self, parent)
        try:
            self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
        except:
            pass

        if len(self.message.message) > 16:
            short = ": "+self.message.message[:16]+".."
        else:
            short = ": "+self.message.message
        if self.message.istask:
            self.setWindowTitle(self.tr("Task")+short)
        elif self.message.isentry:
            self.setWindowTitle(self.tr("Entry")+short)
        else:
            self.setWindowTitle(self.tr("Message")+short)

        # Vertical main layout, 1st row contains buttons etc., 2nd row contains all tasks
        cw = QtGui.QWidget(self)
        self.setCentralWidget(cw)
        self.layout = QtGui.QVBoxLayout(cw)
        self.setObjectName("Ui_Messageview")
        
        # Entries list
        self.listMessages = Ui_List(self)
        self.layout.addWidget(self.listMessages)

        # Description text
        self.uiMessage = Ui_Message(self.message, self.showNewCommentDialog)
        self.uiMessage.enableExtra()
        self.listMessages.addWidget(self.uiMessage)

        comments = self.message.getComments()
        self.persons = {}
        self.persons[self.message.person.id] = self.message.person
        for comment in comments:
            self.addComment(comment)
            self.persons[comment.person.id] = comment.person

        # Create menu bar
        self.menuBar = MessageViewMenuBar(self, self.message)
        self.setMenuBar(self.menuBar)


    def addComment(self, comment):
        if comment.isentry:
            message = Ui_Message(comment, self.viewEntry)
        else:
            message = Ui_Message(comment)
        message.setFlat(True)
        message.setBorder(1)
        message.enableExtra()
        self.listMessages.addWidget(message)


    def viewEntry(self, ui_message, data):
        messageview = Ui_MessageView(ui_message, self)
        messageview.show()
        
        
    def showNewCommentDialog(self, message = None, data = None):
        #self.menuBar.hide()
        dlg = Ui_MessageEditor(self.message, self.persons)
        id = dlg.exec_()
        if id > 0:
            self.addComment(Message(id))
            self.uiMessage.updateContent()
            #scroll = self.listMessages.verticalScrollBar()
            #scroll.setSliderPosition(1000000)


    def closeEvent(self, event):
        self.parentUiMessage.updateContent()
        Config.configSet("save/messageeditor/message", "")
        event.accept()


class MessageViewMenuBar(QtGui.QMenuBar):
    def __init__(self, parent, message):
        QtGui.QMenuBar.__init__(self, parent)
        self.message = message
        
        action = QtGui.QAction(self)
        if self.message.istask:
            action.setText(QtCore.QString(self.tr("New entry")))
        else:
            action.setText(QtCore.QString(self.tr("New comment")))
        #action.setIconText(projects[i].title)
        self.connect(action, QtCore.SIGNAL("triggered()"), parent.showNewCommentDialog);
        self.addAction(action)          
         
        #self.setNativeMenuBar(True)
