# -*- coding: utf-8 -*-
import sys, os, time
import ConfigParser
from datetime import datetime
from dateutil.relativedelta import *

try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui
    
from channel import Channel
from person import Person
from config import Config
from message import Message
from qaikuconnection import QaikuData
from qaikusynchronize import QaikuSynchronize

from ui_frontpage import Ui_Frontpage, LoginButton
from ui_synchronize import Ui_Synchronize
from ui_ibox import Ui_IBox
from ui_mainmenubar import Ui_MainMenuBar
from ui_stream import Ui_Stream
from ui_loading import Ui_Loading
from ui_message import Ui_Message

from sql import *


DATABASE_VERSION = 46


class QaikuClient(QtGui.QMainWindow):
    def __init__(self):
        QtGui.QMainWindow.__init__(self)
        
        Config().windowMain = self
        
        # window properties
        self.setWindowTitle(self.tr("Qaiku client"))
        try:
            self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
        except:
            pass
        self.setAutoFillBackground(True)
        widget = QtGui.QWidget(self)
        self.layout = QtGui.QStackedLayout(widget)
        self.setCentralWidget(widget)
        loading = Ui_Loading()
        loading.setPixmap(QtGui.QPixmap("data/qaiku.png"))
        self.layout.addWidget(loading)
        Config().loading = loading
        self.show()
        
        self.initialize()

        self.doPostInit = True
        self.timer1000ms = QtCore.QTimer(self)
        QtCore.QObject.connect(self.timer1000ms, QtCore.SIGNAL("timeout()"), self.eventTimer1000ms)
        self.timer1000ms.start(1000)
        
        self.timer100ms = QtCore.QTimer(self)
        QtCore.QObject.connect(self.timer100ms, QtCore.SIGNAL("timeout()"), self.eventTimer100ms)


    def postInit(self):
        self.doPostInit = False
        
        #Set global variables
        try:
            Config().currentChannel = Channel(str(Config.configGetString("default/channel")))
        except:
            Config().currentChannel = None
        Config().currentPerson = None
        
        # Preset main content windows
        menubar = Ui_MainMenuBar()
        self.setMenuBar(menubar)
        Config().menubar = menubar
        frontpage = Ui_Frontpage()
        self.layout.addWidget(frontpage)
        Config().frontpage = frontpage
        if Config.mode_workstreamer:
            tasklist = Ui_Stream(style = "tasks")
            self.layout.addWidget(tasklist)
            Config().tasklist = tasklist
        channelview = Ui_Stream(style = "channel")
        self.layout.addWidget(channelview)
        Config().channelview = channelview
        stream = Ui_Stream()
        self.layout.addWidget(stream)
        Config().stream = stream

        self.timer100ms.start(100)

        frontpage.getUsers()
        
        self.setObjectName("Main")
        
        # automatically login with last user used
        #try:
        if len(str(Config.configGetString("default/login"))):
            person = Person(str(Config.configGetString("default/login")))
            self.login(person)


    def eventTimer1000ms(self):
        if self.doPostInit == True:
            self.postInit()
            if len(Channel.channelGetAll()) < 1 and Config().currentPerson != None:
                Ui_IBox(self, "First login, you should synchronize now")
                Config().windowMain.showWidget("sync")


    def eventTimer100ms(self):
        items = Config().sync.readStatus()
        for item in items:
            name = item[0]
            id = item[1]
            if name == "channel":
                channel = Channel(id)
                if Config().currentChannel == None:
                    Config().currentChannel = channel
                    Config().channelview.updateStream()
                    if Config.mode_workstreamer:
                        Config().tasklist.updateStream()
            #elif name == "message":
                #message = Message(id)
                #Config().stream.addMessage(message)
                #Config().channelview.addMessage(message)
            elif name == "ready":
                Ui_IBox(self, self.tr("Synchronization finished"))
                if id == True:
                    Config().stream.updateStream()
                    Config().channelview.updateStream()
                    if Config.mode_workstreamer:
                        Config().tasklist.updateStream()
            elif name == "error":
                Ui_IBox(self, self.tr(str(id)))
        

    # Switches view
    def showWidget(self, mode='frontpage'):
        if (mode == "tasklist" or mode == "channel") and Config().currentChannel == None:
            Ui_IBox(self, self.tr("No channels synchronized yet, this menu is disabled for now"))
            mode = "stream"
        if Config().currentPerson != None:
            self.mode = mode
            if self.mode == "tasklist":
                self.layout.setCurrentWidget(Config().tasklist)
            elif self.mode == "channel":
                self.layout.setCurrentWidget(Config().channelview)
            else:
                self.mode = "stream"
                e = self.layout.setCurrentWidget(Config().stream)
            Config().menubar.setMode(self.mode)
            Config().configSet("default/mainwindow/mode", self.mode)
        else:
            self.mode = 'frontpage'
            Config().menubar.setMode(self.mode)
            self.layout.setCurrentWidget(Config().frontpage)


    def login(self, person):
        Config().currentPerson = person
        Config().sync.setApiKey(person.getApiKey())
        Config().sync.setHost(person.server)
        #self.QC.qaikuAuthenticate(callback = self.login_real)
        Config.configSet("default/login", str(person.getLogin()))
        self.showWidget(Config().configGetString("default/mainwindow/mode"))

        Config().stream.updateStream()
        Config().channelview.updateStream()
        Config().tasklist.updateStream()

        if person.new == 1:
            Ui_IBox(self, "First login, you should synchronize now")
            dlg = Ui_Synchronize()
            dlg.exec_()
            person.new = 0
            person.update()
            
    #def login_real(self, request):
        #if request["status"] == 200:
            ##Ui_IBox(self, "Logged in as "+self.currentPerson.getName(), 1000)
            #self.showWidget('tasklist')
        #else:
            #Ui_IBox(self, "Logging unsuccessfull with current apikey", 1000)

    def logout(self):
        Config().currentPerson = None
        Config().configSet("default/login", "")
        self.showWidget('frontpage')

    def initialize(self):
        # when first time running this app
        if Config.configGetInt("version") == 0:
            Config.configSet("version", DATABASE_VERSION)
            Config.configSet("default/login", "")
            Config.configSet("default/channel", "")
            Config().configSet("default/mainwindow/mode", "stream")
            Config.configSet("sync/channels/since", self.tr("One week"))
            Config.configSet("sync/users/enabled", 1)
        # when app has been upgraded or database is missing
        if Config.configGetInt("version") != DATABASE_VERSION:
            #if Ui_DatabaseUpgrade.upgrade(self) == 0:
                #sys.exit(1)
            Config.configSet("version", DATABASE_VERSION)

        Config().configSet("default/stream/messages", 50)
        Config().configSet("default/stream/messagesall", 0)


if __name__ == '__main__':
    reload(sys)
    sys.setdefaultencoding("utf-8")

    sync = QaikuSynchronize()
    Config().sync = sync

    Config().configSet("style/ui_list", "background-color: #202020; border: 1px solid #181818")

    Config.mode_qaikuclient = True
    Config.mode_workstreamer = True


    if SQLConnection.dbtype() == "midgard":
        conn = SQLConnection("/home/user/qaikuclient.sqlite", "schema_midgard.cfg", "/home/user/qaikublobs")
    else:
        conn = SQLConnection("/home/user/qaikuclient.sqlite", "schema.cfg", "/home/user/qaikublobs")
        conn.create_database()

    app = QtGui.QApplication(sys.argv)
    qaikuclient = QaikuClient()
    r = app.exec_()
    #Config().sync.stop()
    sys.exit(r)

