# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui

from config import Config
from person import Person
from message import Message

from ui_button import Ui_PushButton
from ui_ibox import Ui_IBox
from ui_persons import Ui_Persons
from ui_list import Ui_List, Ui_ListWidget
from qaikusynchronize import QaikuSynchronization


class Ui_MessageEditor(QtGui.QDialog):
    def __init__(self, replyTo = None, persons = {}):
        QtGui.QDialog.__init__(self)
        self.setObjectName("Ui_MessageEditor")
        if replyTo == None:
            channel = self.tr("my stream")
            if Config.configIs("view", "channel"):
                channel = "#"+Config().currentChannel.getName()
            self.setWindowTitle(self.tr("New message to")+" "+channel)
        else:
            if replyTo.istask:
                self.setWindowTitle(self.tr("New entry for task"))
            else:
                self.setWindowTitle(self.tr("New comment"))

        self.replyTo = replyTo
        
        # main layout
        self.layout = QtGui.QVBoxLayout(self)

        # ping selection, create button
        layout = QtGui.QHBoxLayout()
        self.layout.addLayout(layout)

        list = Ui_List(self, False)
        layout.addWidget(list, 0, QtCore.Qt.AlignLeft)
        for person_id, person in persons.items():
            icon = Ui_ListWidget(parent = self, callback = self.addPing, userdata = person)
            icon.setIconMode(True)
            icon.setIcon(person.getAvatar())
            icon.setFlat(True)
            list.addWidget(icon)
        
        if replyTo == None:
            button = QtGui.QPushButton(self.tr("Create"))
        else:
            button = QtGui.QPushButton(self.tr("Add"))
        button.setDefault(True)
        self.connect(button, QtCore.SIGNAL("clicked()"), self.saveMessage)
        layout.addWidget(button, 100, QtCore.Qt.AlignRight)

        # message editor
        self.message = QtGui.QTextEdit(self)
        text = str(Config.configGetString("save/messageeditor/message"))
        self.message.setText(text)
        self.layout.addWidget(self.message)
        self.message.setFocus()
        cursor = self.message.textCursor()
        cursor.select(QtGui.QTextCursor.Document)
        self.message.setTextCursor(cursor)

        # completeness editor
        layout = QtGui.QHBoxLayout()
        self.layout.addLayout(layout)

        if replyTo == None:
            pass
        elif replyTo.istask:
            self.completeness_info = QtGui.QLabel(self)
            self.completeness_info.setText(self.tr("Completed:"))
            layout.addWidget(self.completeness_info, 0)
            self.completeness = QtGui.QSlider(self)
            self.completeness.setOrientation(QtCore.Qt.Horizontal)
            self.completeness.setRange(0, 100);
            self.completeness.setTracking(True)
            self.completeness.setSingleStep(1)
            self.completeness.setTickPosition(QtGui.QSlider.TicksBothSides)
            layout.addWidget(self.completeness, 100)
            self.connect(self.completeness, QtCore.SIGNAL("valueChanged(int)"), self.updateCompleteness)
            self.completeness_label = QtGui.QLabel(self)
            self.completeness_label.setText("   0%")
            font = self.completeness_label.font()
            font.setPointSize(font.pointSize() + 4)
            layout.addWidget(self.completeness_label, 0)
            self.completeness.setValue(int(replyTo.completeness))
            self.updateCompleteness(int(replyTo.completeness))
        

    def updateCompleteness(self, completeness):
        palette = self.completeness_label.palette()
        g = 50 + (completeness * 2)
        r = 255 - (completeness * 2)
        palette.setColor(QtGui.QPalette.WindowText, QtGui.QColor(r, g, 100))
        self.completeness_label.setPalette(palette)
        self.completeness_label.setText(" %s%%" % (completeness))
        
        
    def closeEvent(self, event):
        Config.configSet("save/messageeditor/message", self.message.toPlainText())
        event.accept()


    def addPing(self, button, person):
        cursor = self.message.textCursor()
        cursor.insertText("@"+str(person.getScreenName())+" ")
        self.message.setFocus()

        
    def saveMessage(self):
        if self.validateInput() == False:
            return
            
        #create the new message
        message = Message()
        message.language = "fi"
        message.message = str(self.message.toPlainText())
        message.ownerid = int(Config().currentPerson.id)
        message.channelid = 0
        if self.replyTo != None:
            message.sourceid = self.replyTo.id
            if self.replyTo.istask == False:
                message.comment = 1
            else:
                message.channelid = self.replyTo.channelid
                message.comment = 0
                message.completeness = int(self.completeness.value())
                message.deadline = self.replyTo.deadline
                message.priority = self.replyTo.priority
        elif Config.configIs("view", "channel"):
            message.channelid = int(Config().currentChannel.id)
            message.comment = 0
        message.create()
        if self.replyTo == None:
            Config().stream.insertMessage(message)
            if Config.configIs("view", "stream"):
                pass
            else:
                Config().channelview.insertMessage(message)
        elif self.replyTo.istask:
            self.replyTo.completeness = message.completeness
            self.replyTo.update()
            Config().stream.insertMessage(message)
            Config().channelview.insertMessage(message)
        self.done(message.id)
        Config().sync.enableSection("users", False)
        Config().sync.enableSection("channels", False)
        Config().sync.enableSection("post", True)
        Config().sync.synchronize(False)
        


    def validateInput(self):
        message = self.message.toPlainText()

        error = None
        if len(message) <= 0:
            error = self.tr("You cannot post empty message")

        if error != None:
            Ui_IBox(self, error)
            return False
            
        return True

        