# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui
import time

from config import Config
from person import Person
from qaikuconnection import QaikuConnection

from ui_usereditor import Ui_UserEditor


class Ui_Frontpage(QtGui.QWidget):
    def __init__(self):
        QtGui.QWidget.__init__(self)
        try:
            self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
        except:
            pass

        # Set UI elements
        self.setObjectName("Ui_Frontpage")
        self.layout = QtGui.QGridLayout(self)

        self.layout.setColumnStretch(0, 100)
        self.layout.setColumnStretch(1, 0)
        self.layout.setVerticalSpacing(10)
        
        self.createUserButton = QtGui.QPushButton(QtGui.QIcon("data/no_avatar.gif"), QtCore.QString(self.tr("Setup a New User")))
        self.layout.addWidget(self.createUserButton, 99, 0)
        self.padding = QtGui.QLabel("")
        self.layout.addWidget(self.padding, 100, 0)
        
        #QtCore.QMetaObject.connectSlotsByName(self)

        # Create usereditor
        QtCore.QObject.connect(self.createUserButton, QtCore.SIGNAL("clicked()"), self.openUserEditor)

        self.buttons = dict()
        self.numrows = 0

    def getUsers(self):
        persons = Person.personGetAllActive()
        if len(persons) > 0:
            for person in persons:
                self.addLoginButton(person)
        else:
            if self.openUserEditor() == 1:
                persons = Person.personGetAllActive()
                if len(persons) > 0:
                    Config.configSet("default/login", str(persons[0].getLogin()))
                
    def openUserEditor(self):
        ue = Ui_UserEditor()
        return ue.exec_()
        
    def removeButtons(self, index):
        self.buttons[index, 0].hide()
        self.buttons[index, 1].hide()
        self.numrows -= 1
        
    def addLoginButton(self, person):
        # Login button
        button_login = LoginButton(self, person)
        self.layout.addWidget(button_login, self.numrows, 0)
        self.buttons[self.numrows, 0] = button_login
        # Delete button
        button_delete = DeleteButton(self, person, self.numrows)
        self.layout.addWidget(button_delete, self.numrows, 1)
        self.buttons[self.numrows, 1] = button_delete
        
        self.numrows += 1

        return button_login

        
class LoginButton(QtGui.QPushButton):
    def __init__(self, frontpage, person):
        self.frontpage = frontpage
        self.person = person
        
        icon = QtGui.QIcon(person.getAvatar())
        QtGui.QPushButton.__init__(self, icon, QtCore.QString("Login as "+self.person.getScreenName()))
        QtCore.QObject.connect(self, QtCore.SIGNAL("clicked()"), self.pushed)
       
    def __del__(self):
        print "delete user not implemented",self.person.getScreenName()
        #Config().windowMain.unregisterItem(self)
        #QtGui.QPushButton.__del__(self)
        
    def pushed(self):
        print "login",self.person.username
        Config().windowMain.login(self.person)

    def setAvatar(self, avatarFile):
        self.setIcon(QtGui.QIcon(avatarFile))


class DeleteButton(QtGui.QPushButton):
    def __init__(self, frontpage, person, index):
        #self.frontpage = frontpage
        self.person = person
        self.frontpage = frontpage
        self.index = index
        QtGui.QPushButton.__init__(self)
        self.setIcon(QtGui.QIcon("data/delete.png")) #QtCore.QString("Delete"))
        QtCore.QObject.connect(self, QtCore.SIGNAL("clicked()"), self.pushed)
        
    def pushed(self):
        temp = self.person.getScreenName()
        self.person.setActive(False)
        print "User "+temp+" deleted"
        self.frontpage.removeButtons(self.index)

    