#ifndef QEMAEMO5DYNAMICHOMESCREENWIDGET_H
#define QEMAEMO5DYNAMICHOMESCREENWIDGET_H

#include <QtCore>
#include <QtGui>

#define WIDGET_SETTINGS_BASE_APPLETID QApplication::applicationName() + "-widget-"

class QeMaemo5DynamicHomescreenWidget : public QWidget
{
    Q_OBJECT

    friend class QeMaemo5DynamicWidgetHelper;

private:

    bool _isPressed;
    bool _settingsDialogAvailable;
    bool _isVisibleOnCurrentHomescreen;
    bool _shouldRegister;
    QTimer *_focusHackTimer; // Hack needed because of a bug that the desktop doesn't retake focus.
    QString _appletId;

protected:

    virtual bool x11Event(XEvent *event);
    virtual void paintEvent(QPaintEvent *event);
    virtual void mousePressEvent(QMouseEvent *event);
    virtual void mouseReleaseEvent(QMouseEvent *event);
    virtual void showEvent(QShowEvent *event);
    virtual void closeEvent(QCloseEvent *event);

    virtual void showSettingsDialog();
    virtual bool restoreWidgetState();

protected Q_SLOTS:

    void checkFocusHack();

public:

    explicit QeMaemo5DynamicHomescreenWidget(bool settingsAvailable = false, QWidget *parent = 0);
    ~QeMaemo5DynamicHomescreenWidget();

    QString appletId();
    void saveSetting(const QString &key, const QVariant &data);
    QVariant loadSetting(const QString &key, const QVariant &defaultValue = QVariant());

    bool isVisibleOnCurrentHomescreen();
    bool settingsDialogAvailable();
    bool isPressed();
    bool shouldRegister();
    void setShouldRegister(bool value);
    bool restoreAppletId(const QString &restoredAppletId);

Q_SIGNALS:

    void isVisibleOnCurrentHomescreenChanged(bool isVisibleOnCurrentHomescreen);

};

#endif // QEMAEMO5DYNAMICHOMESCREENWIDGET_H
