
#ifndef QEMAEMO5ROTATOR_H
#define QEMAEMO5ROTATOR_H

//----------
// Provides a means of WORKING automatic rotation for Maemo 5 apps. (The default Qt solution is buggy.)
//----------

#include <QWidget>

class QeMaemo5Rotator : private QObject
{
    Q_OBJECT

public:

    enum RotationBehavior
    {
        AutomaticBehavior = 0,
        LandscapeBehavior = 1,
        PortraitBehavior = 2,
        StartupOnlyBehavior = 3,
    };

    enum Orientation
    {
        LandscapeOrientation = 0,
        PortraitOrientation = 1
    };

private:

    bool _isSetUp;
    RotationBehavior _currentBehavior;
    Orientation _currentOrientation;

public:

    explicit QeMaemo5Rotator(RotationBehavior behavior = LandscapeBehavior, QWidget *parent = NULL);
    ~QeMaemo5Rotator();

    const RotationBehavior currentBehavior();
    const Orientation currentOrientation();
    void setCurrentBehavior(RotationBehavior value);
    void setCurrentOrientation(Orientation value);
    void adjustOrientation();

private slots:

    void on_orientation_changed(const QString& newOrienation);

signals:

    void orientationChanged(Orientation orientation);

};

#endif // QEMAEMO5ROTATOR_H
