
#include "qemaemo5rotator.h"

#include <QtCore>

#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
#include <mce/dbus-names.h>
#include <mce/mode-names.h>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>
#endif

QeMaemo5Rotator::QeMaemo5Rotator(RotationBehavior behavior, QWidget *parent)
    : QObject(parent),
    _isSetUp(false)
{
    setCurrentBehavior(behavior);
}

QeMaemo5Rotator::~QeMaemo5Rotator()
{
#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
    QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_ACCELEROMETER_DISABLE_REQ));
#endif
}

const QeMaemo5Rotator::RotationBehavior QeMaemo5Rotator::currentBehavior()
{
    return _currentBehavior;
}

const QeMaemo5Rotator::Orientation QeMaemo5Rotator::currentOrientation()
{
    return _currentOrientation;
}

void QeMaemo5Rotator::setCurrentBehavior(QeMaemo5Rotator::RotationBehavior value)
{
#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
    if (value == _currentBehavior && _isSetUp)
        return;

    _isSetUp = true;
    _currentBehavior = value;

    if (value == QeMaemo5Rotator::AutomaticBehavior)
    {
        adjustOrientation();

        QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_ACCELEROMETER_ENABLE_REQ));
        QDBusConnection::systemBus().connect(QString(), MCE_SIGNAL_PATH, MCE_SIGNAL_IF, MCE_DEVICE_ORIENTATION_SIG, this, SLOT(on_orientation_changed(QString)));
    }
    else if (value == QeMaemo5Rotator::StartupOnlyBehavior)
    {
        adjustOrientation();
    }
    else
    {
        QDBusConnection::systemBus().disconnect(QString(), MCE_SIGNAL_PATH, MCE_SIGNAL_IF, MCE_DEVICE_ORIENTATION_SIG, this, SLOT(on_orientation_changed(QString)));
        QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_ACCELEROMETER_DISABLE_REQ));

        if (value == QeMaemo5Rotator::PortraitBehavior)
        {
            setCurrentOrientation(QeMaemo5Rotator::PortraitOrientation);
        }
        else
        {
            setCurrentOrientation(QeMaemo5Rotator::LandscapeOrientation);
        }
    }
#endif
}

void QeMaemo5Rotator::setCurrentOrientation(QeMaemo5Rotator::Orientation value)
{
    _currentOrientation = value;
    QWidget *par = (QWidget*)parent();

    switch (value)
    {
    case QeMaemo5Rotator::PortraitOrientation:
        qDebug() << "portrait orientation is set now";
        if (par != NULL)
        {
#if defined(Q_WS_MAEMO_5)
            par->setAttribute(Qt::WA_Maemo5LandscapeOrientation, false);
            par->setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
#endif
        }
        orientationChanged(QeMaemo5Rotator::PortraitOrientation);
        break;
    case QeMaemo5Rotator::LandscapeOrientation:
        qDebug() << "landscape orientation is set now";
        if (par != NULL)
        {
#if defined(Q_WS_MAEMO_5)
            par->setAttribute(Qt::WA_Maemo5PortraitOrientation, false);
            par->setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
#endif
        }
        orientationChanged(QeMaemo5Rotator::LandscapeOrientation);

        break;
    }
}

void QeMaemo5Rotator::on_orientation_changed(const QString& newOrientation)
{
    if (newOrientation == QLatin1String(MCE_ORIENTATION_PORTRAIT) || newOrientation == QLatin1String(MCE_ORIENTATION_PORTRAIT_INVERTED))
    {
        setCurrentOrientation(QeMaemo5Rotator::PortraitOrientation);
    }
    else
    {
        setCurrentOrientation(QeMaemo5Rotator::LandscapeOrientation);
    }
}

void QeMaemo5Rotator::adjustOrientation()
{
    QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_ACCELEROMETER_ENABLE_REQ));
    on_orientation_changed(QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_DEVICE_ORIENTATION_GET)).arguments().first().toString());
    QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_ACCELEROMETER_DISABLE_REQ));
}
