#ifndef QEMAEMO5NOTIFICATION_H
#define QEMAEMO5NOTIFICATION_H

//----------
// Provides a Qt abstraction of Maemo5's SMS/E-mail-style notifications.
//----------

#include <QtCore>
#include <QApplication>
#include <QtDBus/QtDBus>

typedef QPair<QString, QString> StringPair;

class QeMaemo5Notification
{
private:

    static QString *lastTitle;

public:

    static const int EXPIRES_NEVER;

    static const int DEFAULT_TIMEOUT;

    static const QString DEFAULT_ICON;

    static const QString APPLICATION_ICON_SETTING_KEY;

    static const QString applicationIcon();

    static void setApplicationIcon(const QString &icon);

    static bool information(const QString &text, const QString &title = QApplication::applicationName(), int timeout = DEFAULT_TIMEOUT, const QDBusMessage *message = NULL, const QList<StringPair> &hints = QList<StringPair>(), const QString &icon = applicationIcon());

    static bool information(const QString &text, const QString &title, int timeout, const QString &icon);

    static bool nonExpiringInformation(const QString &text, const QString &title = QApplication::applicationName(), const QDBusMessage *message = NULL, const QList<StringPair> &hints = QList<StringPair>(), const QString &icon = applicationIcon());

    static bool nonExpiringInformation(const QString &text, const QString &title, const QString &icon);

};

#endif // QEMAEMO5NOTIFICATION_H
