
#define QT_NO_KEYWORDS

#include "qemaemo5notification.h"
#include "qesettingsmanager.h"

#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
#include <hildon-notify/hildon/hildon-notification.h>
#endif

const int QeMaemo5Notification::EXPIRES_NEVER =
#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
        NOTIFY_EXPIRES_NEVER;
#else
0;
#endif

const int QeMaemo5Notification::DEFAULT_TIMEOUT =
#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
        NOTIFY_EXPIRES_DEFAULT;
#else
0;
#endif

const QString QeMaemo5Notification::DEFAULT_ICON("general_web");

const QString QeMaemo5Notification::APPLICATION_ICON_SETTING_KEY("QeMaemo5Notification_application_icon");

QString *QeMaemo5Notification::lastTitle = NULL;

const QString QeMaemo5Notification::applicationIcon()
{
    return QeSettingsManager::retrieveSetting(APPLICATION_ICON_SETTING_KEY, DEFAULT_ICON);
}

void QeMaemo5Notification::setApplicationIcon(const QString &icon)
{
    QeSettingsManager::storeSetting(APPLICATION_ICON_SETTING_KEY, icon);
}

bool QeMaemo5Notification::information(const QString &text, const QString &title, int timeout, const QDBusMessage *message, const QList<StringPair> &hints, const QString &icon)
{
#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
    bool successful = true;

    if (lastTitle != NULL && *lastTitle != title && notify_is_initted())
    {
        notify_uninit();
        lastTitle = new QString(title);
    }

    notify_init(title.toLatin1().data());
    HildonNotification *notification = hildon_notification_new(title.toLatin1().data(), text.toLatin1().data(), icon.toLatin1().data(), NULL);

    if (notification == NULL)
        return false;

    notify_notification_set_timeout(NOTIFY_NOTIFICATION(notification), timeout);

    if (message != NULL)
    {
        if (message->arguments().count() > 0)
        {
            qDebug() << "D-Bus methods with more than zero arguments are not supported currently.";
            delete notification;
            return false;
        }
        hildon_notification_add_dbus_action(notification,
                                            "default",
                                            QApplication::applicationName().toLatin1().data(),
                                            message->service().toLatin1().data(),
                                            message->path().toLatin1().data(),
                                            message->interface().toLatin1().data(),
                                            message->member().toLatin1().data(),
                                            -1);
    }


    for (int i = 0, hintCount = hints.count(); i < hintCount; i++)
    {
        notify_notification_set_hint_string(NOTIFY_NOTIFICATION(notification), hints[i].first.toLatin1().data(), hints[i].second.toLatin1().data());
    }

    if (!notify_notification_show(NOTIFY_NOTIFICATION(notification), NULL))
        successful = false;

    g_object_unref(notification);
    return successful;
#else
    return false;
#endif
}

bool QeMaemo5Notification::information(const QString &text, const QString &title, int timeout, const QString &icon)
{
    return information(text, title, timeout, NULL, QList<QPair<QString, QString> >(), icon);
}

bool QeMaemo5Notification::nonExpiringInformation(const QString &text, const QString &title, const QDBusMessage *message, const QList<StringPair> &hints, const QString &icon)
{
    return information(text, title, QeMaemo5Notification::EXPIRES_NEVER, message, hints, icon);
}

bool QeMaemo5Notification::nonExpiringInformation(const QString &text, const QString &title, const QString &icon)
{
    return information(text, title, QeMaemo5Notification::EXPIRES_NEVER, NULL, QList<StringPair>(), icon);
}
