/*
 * Interface wrapper code.
 *
 * Generated by SIP snapshot-4.10.1-637497440cb5 on Sat Apr 24 18:59:47 2010
 *
 * Copyright (c) 2010 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt.
 * 
 * This file may be used under the terms of the GNU General Public
 * License versions 2.0 or 3.0 as published by the Free Software
 * Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
 * included in the packaging of this file.  Alternatively you may (at
 * your option) use any later version of the GNU General Public
 * License if such license has been publicly approved by Riverbank
 * Computing Limited (or its successors, if any) and the KDE Free Qt
 * Foundation. In addition, as a special exception, Riverbank gives you
 * certain additional rights. These rights are described in the Riverbank
 * GPL Exception version 1.1, which can be found in the file
 * GPL_EXCEPTION.txt in this package.
 * 
 * Please review the following information to ensure GNU General
 * Public Licensing requirements will be met:
 * http://trolltech.com/products/qt/licenses/licensing/opensource/. If
 * you are unsure which license is appropriate for your use, please
 * review the following information:
 * http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 * or contact the sales department at sales@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 62 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 39 "sipQtCoreQStringList_0.cpp"

#line 41 "/home/maemo/python-qt4-4.7/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 43 "sipQtCoreQStringList_0.cpp"
#line 41 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 46 "sipQtCoreQStringList_0.cpp"
#line 41 "/home/maemo/python-qt4-4.7/sip/QtCore/qregexp.sip"
#include <qregexp.h>
#line 49 "sipQtCoreQStringList_0.cpp"
#line 40 "/home/maemo/python-qt4-4.7/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 52 "sipQtCoreQStringList_0.cpp"


PyDoc_STRVAR(doc_QStringList_0_sort, "QStringList.sort()");

extern "C" {static PyObject *meth_QStringList_0_sort(PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_sort(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QStringList, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->sort();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_sort, doc_QStringList_0_sort);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_join, "QStringList.join(QString) -> QString");

extern "C" {static PyObject *meth_QStringList_0_join(PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_join(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;
        QStringList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QStringList, &sipCpp, sipType_QString,&a0, &a0State))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->join(*a0));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_join, doc_QStringList_0_join);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_filter, "QStringList.filter(QString, Qt.CaseSensitivity cs=Qt.CaseSensitive) -> QStringList\n"
    "QStringList.filter(QRegExp) -> QStringList");

extern "C" {static PyObject *meth_QStringList_0_filter(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_filter(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;
        Qt::CaseSensitivity a1 = Qt::CaseSensitive;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_cs,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|E", &sipSelf, sipType_QStringList, &sipCpp, sipType_QString,&a0, &a0State, sipType_Qt_CaseSensitivity, &a1))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(sipCpp->filter(*a0,a1));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return sipConvertFromNewType(sipRes,sipType_QStringList,NULL);
        }
    }

    {
        const QRegExp * a0;
        QStringList *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "BJ9", &sipSelf, sipType_QStringList, &sipCpp, sipType_QRegExp, &a0))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(sipCpp->filter(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_filter, doc_QStringList_0_filter);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_contains, "QStringList.contains(QString, Qt.CaseSensitivity cs=Qt.CaseSensitive) -> bool");

extern "C" {static PyObject *meth_QStringList_0_contains(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_contains(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;
        Qt::CaseSensitivity a1 = Qt::CaseSensitive;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_cs,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|E", &sipSelf, sipType_QStringList, &sipCpp, sipType_QString,&a0, &a0State, sipType_Qt_CaseSensitivity, &a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->contains(*a0,a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_contains, doc_QStringList_0_contains);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_replaceInStrings, "QStringList.replaceInStrings(QString, QString, Qt.CaseSensitivity cs=Qt.CaseSensitive) -> QStringList\n"
    "QStringList.replaceInStrings(QRegExp, QString) -> QStringList");

extern "C" {static PyObject *meth_QStringList_0_replaceInStrings(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_replaceInStrings(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;
        const QString * a1;
        int a1State = 0;
        Qt::CaseSensitivity a2 = Qt::CaseSensitive;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            NULL,
            sipName_cs,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1J1|E", &sipSelf, sipType_QStringList, &sipCpp, sipType_QString,&a0, &a0State, sipType_QString,&a1, &a1State, sipType_Qt_CaseSensitivity, &a2))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->replaceInStrings(*a0,*a1,a2);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);
            sipReleaseType(const_cast<QString *>(a1),sipType_QString,a1State);

            return sipConvertFromType(sipRes,sipType_QStringList,NULL);
        }
    }

    {
        const QRegExp * a0;
        const QString * a1;
        int a1State = 0;
        QStringList *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "BJ9J1", &sipSelf, sipType_QStringList, &sipCpp, sipType_QRegExp, &a0, sipType_QString,&a1, &a1State))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->replaceInStrings(*a0,*a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a1),sipType_QString,a1State);

            return sipConvertFromType(sipRes,sipType_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_replaceInStrings, doc_QStringList_0_replaceInStrings);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_indexOf, "QStringList.indexOf(QString, int from=0) -> int\n"
    "QStringList.indexOf(QRegExp, int from=0) -> int");

extern "C" {static PyObject *meth_QStringList_0_indexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_indexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;
        int a1 = 0;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_QStringList, &sipCpp, sipType_QString,&a0, &a0State, &a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOf(*a0,a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        const QRegExp * a0;
        int a1 = 0;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|i", &sipSelf, sipType_QStringList, &sipCpp, sipType_QRegExp, &a0, &a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->indexOf(*a0,a1);
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_indexOf, doc_QStringList_0_indexOf);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_lastIndexOf, "QStringList.lastIndexOf(QString, int from=-1) -> int\n"
    "QStringList.lastIndexOf(QRegExp, int from=-1) -> int");

extern "C" {static PyObject *meth_QStringList_0_lastIndexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_lastIndexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;
        int a1 = -1;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1|i", &sipSelf, sipType_QStringList, &sipCpp, sipType_QString,&a0, &a0State, &a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->lastIndexOf(*a0,a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        const QRegExp * a0;
        int a1 = -1;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            NULL,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ9|i", &sipSelf, sipType_QStringList, &sipCpp, sipType_QRegExp, &a0, &a1))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->lastIndexOf(*a0,a1);
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_lastIndexOf, doc_QStringList_0_lastIndexOf);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_removeDuplicates, "QStringList.removeDuplicates() -> int");

extern "C" {static PyObject *meth_QStringList_0_removeDuplicates(PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_removeDuplicates(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QStringList, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->removeDuplicates();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_removeDuplicates, doc_QStringList_0_removeDuplicates);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_clear, "QStringList.clear()");

extern "C" {static PyObject *meth_QStringList_0_clear(PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QStringList, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->clear();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_clear, doc_QStringList_0_clear);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_isEmpty, "QStringList.isEmpty() -> bool");

extern "C" {static PyObject *meth_QStringList_0_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_isEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QStringList, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isEmpty();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_isEmpty, doc_QStringList_0_isEmpty);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_append, "QStringList.append(QString)");

extern "C" {static PyObject *meth_QStringList_0_append(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_append(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_str,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_QStringList, &sipCpp, sipType_QString,&a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->append(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_append, doc_QStringList_0_append);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_prepend, "QStringList.prepend(QString)");

extern "C" {static PyObject *meth_QStringList_0_prepend(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_prepend(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_str,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_QStringList, &sipCpp, sipType_QString,&a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->prepend(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_prepend, doc_QStringList_0_prepend);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_insert, "QStringList.insert(int, QString)");

extern "C" {static PyObject *meth_QStringList_0_insert(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_insert(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        const QString * a1;
        int a1State = 0;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
            sipName_str,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiJ1", &sipSelf, sipType_QStringList, &sipCpp, &a0, sipType_QString,&a1, &a1State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->insert(a0,*a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a1),sipType_QString,a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_insert, doc_QStringList_0_insert);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_replace, "QStringList.replace(int, QString)");

extern "C" {static PyObject *meth_QStringList_0_replace(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_replace(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        const QString * a1;
        int a1State = 0;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
            sipName_str,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BiJ1", &sipSelf, sipType_QStringList, &sipCpp, &a0, sipType_QString,&a1, &a1State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->replace(a0,*a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a1),sipType_QString,a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_replace, doc_QStringList_0_replace);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_removeAt, "QStringList.removeAt(int)");

extern "C" {static PyObject *meth_QStringList_0_removeAt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_removeAt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_QStringList, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->removeAt(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_removeAt, doc_QStringList_0_removeAt);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_removeAll, "QStringList.removeAll(QString) -> int");

extern "C" {static PyObject *meth_QStringList_0_removeAll(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_removeAll(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_str,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_QStringList, &sipCpp, sipType_QString,&a0, &a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->removeAll(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_removeAll, doc_QStringList_0_removeAll);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_takeAt, "QStringList.takeAt(int) -> QString");

extern "C" {static PyObject *meth_QStringList_0_takeAt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_takeAt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi", &sipSelf, sipType_QStringList, &sipCpp, &a0))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->takeAt(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_takeAt, doc_QStringList_0_takeAt);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_takeFirst, "QStringList.takeFirst() -> QString");

extern "C" {static PyObject *meth_QStringList_0_takeFirst(PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_takeFirst(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QStringList, &sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->takeFirst());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_takeFirst, doc_QStringList_0_takeFirst);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_takeLast, "QStringList.takeLast() -> QString");

extern "C" {static PyObject *meth_QStringList_0_takeLast(PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_takeLast(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QStringList, &sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QString(sipCpp->takeLast());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_takeLast, doc_QStringList_0_takeLast);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_move, "QStringList.move(int, int)");

extern "C" {static PyObject *meth_QStringList_0_move(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_move(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_from,
            sipName_to,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_QStringList, &sipCpp, &a0, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->move(a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_move, doc_QStringList_0_move);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_swap, "QStringList.swap(int, int)");

extern "C" {static PyObject *meth_QStringList_0_swap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_swap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_i,
            sipName_j,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bii", &sipSelf, sipType_QStringList, &sipCpp, &a0, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->swap(a0,a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_swap, doc_QStringList_0_swap);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_count, "QStringList.count(QString) -> int\n"
    "QStringList.count() -> int");

extern "C" {static PyObject *meth_QStringList_0_count(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_count(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_str,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "BJ1", &sipSelf, sipType_QStringList, &sipCpp, sipType_QString,&a0, &a0State))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->count(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        QStringList *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, NULL, NULL, "B", &sipSelf, sipType_QStringList, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->count();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_count, doc_QStringList_0_count);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_first, "QStringList.first() -> QString");

extern "C" {static PyObject *meth_QStringList_0_first(PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_first(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QStringList, &sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->first();
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes,sipType_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_first, doc_QStringList_0_first);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_last, "QStringList.last() -> QString");

extern "C" {static PyObject *meth_QStringList_0_last(PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_last(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = NULL;

    {
        QStringList *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QStringList, &sipCpp))
        {
            QString *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->last();
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes,sipType_QString,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_last, doc_QStringList_0_last);

    return NULL;
}


PyDoc_STRVAR(doc_QStringList_0_mid, "QStringList.mid(int, int length=-1) -> QStringList");

extern "C" {static PyObject *meth_QStringList_0_mid(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QStringList_0_mid(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = NULL;

    {
        int a0;
        int a1 = -1;
        QStringList *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
            sipName_length,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, NULL, "Bi|i", &sipSelf, sipType_QStringList, &sipCpp, &a0, &a1))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(sipCpp->mid(a0,a1));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_QStringList,NULL);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName_mid, doc_QStringList_0_mid);

    return NULL;
}


extern "C" {static PyObject *slot_QStringList_0___iadd__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QStringList_0___iadd__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QStringList));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QStringList * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QStringList,&a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QStringList::operator+=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QStringList *>(a0),sipType_QStringList,a0State);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString,&a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->QStringList::operator+=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf,sipArg,iconcat_slot);

    return NULL;
}


extern "C" {static PyObject *slot_QStringList_0___ne__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QStringList_0___ne__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QStringList));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QStringList * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QStringList,&a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QStringList::operator!=(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QStringList *>(a0),sipType_QStringList,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,ne_slot,sipType_QStringList,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QStringList_0___eq__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QStringList_0___eq__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QStringList));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QStringList * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QStringList,&a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->QStringList::operator==(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QStringList *>(a0),sipType_QStringList,a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,eq_slot,sipType_QStringList,sipSelf,sipArg);
}


extern "C" {static PyObject *slot_QStringList_0___imul__(PyObject *sipSelf,int a0);}
static PyObject *slot_QStringList_0___imul__(PyObject *sipSelf,int a0)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QStringList));

    if (!sipCpp)
        return 0;


    {
        {
#line 231 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
        QStringList orig(*sipCpp);
        
        sipCpp->clear();
        
        while (a0-- > 0)
            *sipCpp += orig;
#line 1163 "sipQtCoreQStringList_0.cpp"

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }
}


extern "C" {static PyObject *slot_QStringList_0___mul__(PyObject *sipSelf,int a0);}
static PyObject *slot_QStringList_0___mul__(PyObject *sipSelf,int a0)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QStringList));

    if (!sipCpp)
        return 0;


    {
        {
            QStringList *sipRes = 0;

#line 223 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
        sipRes = new QStringList();
        
        while (a0-- > 0)
            *sipRes += *sipCpp;
#line 1190 "sipQtCoreQStringList_0.cpp"

            return sipConvertFromNewType(sipRes,sipType_QStringList,NULL);
        }
    }
}


extern "C" {static PyObject *slot_QStringList_0___add__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QStringList_0___add__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QStringList));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        const QStringList * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QStringList,&a0, &a0State))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new QStringList(sipCpp->QStringList::operator+(*a0));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QStringList *>(a0),sipType_QStringList,a0State);

            return sipConvertFromNewType(sipRes,sipType_QStringList,NULL);
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf,sipArg,concat_slot);

    return NULL;
}


extern "C" {static int slot_QStringList_0___contains__(PyObject *sipSelf,PyObject *sipArg);}
static int slot_QStringList_0___contains__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QStringList));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = NULL;

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QString,&a0, &a0State))
        {
            int sipRes = 0;

#line 216 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
        // It looks like you can't assign QBool to int.
        sipRes = bool(sipCpp->contains(*a0));
#line 1253 "sipQtCoreQStringList_0.cpp"
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return sipRes;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName___contains__, NULL);

    return -1;
}


extern "C" {static PyObject *slot_QStringList_0___getitem__(PyObject *sipSelf,PyObject *sipArg);}
static PyObject *slot_QStringList_0___getitem__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QStringList));

    if (!sipCpp)
        return 0;

    PyObject *sipParseErr = NULL;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            QString *sipRes = 0;
            int sipIsErr = 0;

#line 186 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
        SIP_SSIZE_T idx = sipConvertFromSequenceIndex(a0, sipCpp->count());
        
        if (idx < 0)
            sipIsErr = 1;
        else
            sipRes = new QString(sipCpp->operator[]((int)idx));
#line 1297 "sipQtCoreQStringList_0.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_QString,NULL);
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
            QStringList *sipRes = 0;
            int sipIsErr = 0;

#line 196 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
        SIP_SSIZE_T len, start, stop, step, slicelength, i;
        
        len = sipCpp->count();
        
        if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
            sipIsErr = 1;
        else
        {
            sipRes = new QStringList();
        
            for (i = 0; i < slicelength; ++i)
            {
                (*sipRes) += (*sipCpp)[start];
                start += step;
            }
        }
#line 1331 "sipQtCoreQStringList_0.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes,sipType_QStringList,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName___getitem__, NULL);

    return 0;
}


extern "C" {static int slot_QStringList_0___delitem__(PyObject *sipSelf,PyObject *sipArg);}
static int slot_QStringList_0___delitem__(PyObject *sipSelf,PyObject *sipArg)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QStringList));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = NULL;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            int sipIsErr = 0;

#line 158 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
        int len;
        
        len = sipCpp->count();
        
        if ((a0 = (int)sipConvertFromSequenceIndex(a0, len)) < 0)
            sipIsErr = 1;
        else
            sipCpp->removeAt(a0);
#line 1378 "sipQtCoreQStringList_0.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
            int sipIsErr = 0;

#line 170 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
        SIP_SSIZE_T len, start, stop, step, slicelength, i;
        
        len = sipCpp->count();
        
        if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
            sipIsErr = 1;
        else
            for (i = 0; i < slicelength; ++i)
            {
                sipCpp->removeAt(start);
                start += step - 1;
            }
#line 1407 "sipQtCoreQStringList_0.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName___delitem__, NULL);

    return -1;
}


extern "C" {static int slot_QStringList_0___setitem__(PyObject *sipSelf,PyObject *sipArgs);}
static int slot_QStringList_0___setitem__(PyObject *sipSelf,PyObject *sipArgs)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QStringList));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = NULL;

    {
        int a0;
        const QString * a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "iJ1", &a0, sipType_QString,&a1, &a1State))
        {
            int sipIsErr = 0;

#line 115 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
        int len;
        
        len = sipCpp->count();
        
        if ((a0 = (int)sipConvertFromSequenceIndex(a0, len)) < 0)
            sipIsErr = 1;
        else
            (*sipCpp)[a0] = *a1;
#line 1456 "sipQtCoreQStringList_0.cpp"
            sipReleaseType(const_cast<QString *>(a1),sipType_QString,a1State);

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;
        const QStringList * a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "TJ1", &PySlice_Type, &a0, sipType_QStringList,&a1, &a1State))
        {
            int sipIsErr = 0;

#line 127 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
        SIP_SSIZE_T len, start, stop, step, slicelength, i;
        
        len = sipCpp->count();
        
        if (PySlice_GetIndicesEx((PySliceObject *)a0, len, &start, &stop, &step, &slicelength) < 0)
            sipIsErr = 1;
        else
        {
            int vlen = a1->count();
        
            if (vlen != slicelength)
            {
                sipBadLengthForSlice(vlen, slicelength);
                sipIsErr = 1;
            }
            else
            {
                QStringList::const_iterator it = a1->begin();
        
                for (i = 0; i < slicelength; ++i)
                {
                    (*sipCpp)[start] = *it;
                    start += step;
                    ++it;
                }
            }
        }
#line 1503 "sipQtCoreQStringList_0.cpp"
            sipReleaseType(const_cast<QStringList *>(a1),sipType_QStringList,a1State);

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_QStringList, sipName___setitem__, NULL);

    return -1;
}


extern "C" {static int slot_QStringList_0___len__(PyObject *sipSelf);}
static int slot_QStringList_0___len__(PyObject *sipSelf)
{
    QStringList *sipCpp = reinterpret_cast<QStringList *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_QStringList));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 110 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
        sipRes = sipCpp->count();
#line 1540 "sipQtCoreQStringList_0.cpp"

            return sipRes;
        }
    }
}


extern "C" {static PyObject *slot_QStringList_0___lshift__(PyObject *sipArg0,PyObject *sipArg1);}
static PyObject *slot_QStringList_0___lshift__(PyObject *sipArg0,PyObject *sipArg1)
{
    PyObject *sipParseErr = NULL;

    {
        QStringList * a0;
        int a0State = 0;
        const QString * a1;
        int a1State = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_QStringList, &a0, &a0State, sipType_QString,&a1, &a1State))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_QStringList,a0State);
            sipReleaseType(const_cast<QString *>(a1),sipType_QString,a1State);

            return sipConvertFromType(sipRes,sipType_QStringList,NULL);
        }
    }

    {
        QStringList * a0;
        int a0State = 0;
        const QStringList * a1;
        int a1State = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_QStringList, &a0, &a0State, sipType_QStringList,&a1, &a1State))
        {
            QStringList *sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = &(*a0 << *a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(a0,sipType_QStringList,a0State);
            sipReleaseType(const_cast<QStringList *>(a1),sipType_QStringList,a1State);

            return sipConvertFromType(sipRes,sipType_QStringList,NULL);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return NULL;

    return sipPySlotExtend(&sipModuleAPI_QtCore,lshift_slot,NULL,sipArg0,sipArg1);
}


/* Cast a pointer to a type somewhere in its superclass hierarchy. */
extern "C" {static void *cast_QStringList_0(void *, const sipTypeDef *);}
static void *cast_QStringList_0(void *ptr, const sipTypeDef *targetType)
{
    if (targetType == sipType_QStringList)
        return ptr;

    return NULL;
}


/* Call the instance's destructor. */
extern "C" {static void release_QStringList_0(void *, int);}
static void release_QStringList_0(void *sipCppV,int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<QStringList *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_QStringList_0(void *, SIP_SSIZE_T, const void *);}
static void assign_QStringList_0(void *sipDst, SIP_SSIZE_T sipDstIdx, const void *sipSrc)
{
    reinterpret_cast<QStringList *>(sipDst)[sipDstIdx] = *reinterpret_cast<const QStringList *>(sipSrc);
}


extern "C" {static void *array_QStringList_0(SIP_SSIZE_T);}
static void *array_QStringList_0(SIP_SSIZE_T sipNrElem)
{
    return new QStringList[sipNrElem];
}


extern "C" {static void *copy_QStringList_0(const void *, SIP_SSIZE_T);}
static void *copy_QStringList_0(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new QStringList(reinterpret_cast<const QStringList *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QStringList_0(sipSimpleWrapper *);}
static void dealloc_QStringList_0(sipSimpleWrapper *sipSelf)
{
    if (sipIsPyOwned(sipSelf))
    {
        release_QStringList_0(sipSelf->u.cppPtr,0);
    }
}


extern "C" {static void *init_QStringList_0(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_QStringList_0(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    QStringList *sipCpp = 0;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QStringList();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const QString * a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J1", sipType_QString,&a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QStringList(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QString *>(a0),sipType_QString,a0State);

            return sipCpp;
        }
    }

    {
        const QStringList * a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, NULL, sipUnused, "J1", sipType_QStringList,&a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new QStringList(*a0);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QStringList *>(a0),sipType_QStringList,a0State);

            return sipCpp;
        }
    }

    return NULL;
}


extern "C" {static int convertTo_QStringList_0(PyObject *, void **, int *, PyObject *);}
static int convertTo_QStringList_0(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
    QStringList **sipCppPtr = reinterpret_cast<QStringList **>(sipCppPtrV);

#line 66 "/home/maemo/python-qt4-4.7/sip/QtCore/qstringlist.sip"
// Allow a Python sequence of QStrings whenever a QStringList is expected.

if (sipIsErr == NULL)
{
    if (sipCanConvertToType(sipPy, sipType_QStringList, SIP_NO_CONVERTORS))
        return 1;

    return qpycore_PySequence_Check_QStringList(sipPy);
}

if (sipCanConvertToType(sipPy, sipType_QStringList, SIP_NO_CONVERTORS))
{
    *sipCppPtr = reinterpret_cast<QStringList *>(sipConvertToType(sipPy, sipType_QStringList, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

    return 0;
}

*sipCppPtr = new QStringList(qpycore_PySequence_AsQStringList(sipPy));

return sipGetState(sipTransferObj);
#line 1732 "sipQtCoreQStringList_0.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QStringList_0[] = {
    {(void *)slot_QStringList_0___iadd__, iconcat_slot},
    {(void *)slot_QStringList_0___ne__, ne_slot},
    {(void *)slot_QStringList_0___eq__, eq_slot},
    {(void *)slot_QStringList_0___imul__, irepeat_slot},
    {(void *)slot_QStringList_0___mul__, repeat_slot},
    {(void *)slot_QStringList_0___add__, concat_slot},
    {(void *)slot_QStringList_0___contains__, contains_slot},
    {(void *)slot_QStringList_0___getitem__, getitem_slot},
    {(void *)slot_QStringList_0___delitem__, delitem_slot},
    {(void *)slot_QStringList_0___setitem__, setitem_slot},
    {(void *)slot_QStringList_0___len__, len_slot},
    {(void *)slot_QStringList_0___lshift__, lshift_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QStringList_0[] = {
    {SIP_MLNAME_CAST(sipName_append), (PyCFunction)meth_QStringList_0_append, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_append)},
    {SIP_MLNAME_CAST(sipName_clear), meth_QStringList_0_clear, METH_VARARGS, SIP_MLDOC_CAST(doc_QStringList_0_clear)},
    {SIP_MLNAME_CAST(sipName_contains), (PyCFunction)meth_QStringList_0_contains, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_contains)},
    {SIP_MLNAME_CAST(sipName_count), (PyCFunction)meth_QStringList_0_count, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_count)},
    {SIP_MLNAME_CAST(sipName_filter), (PyCFunction)meth_QStringList_0_filter, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_filter)},
    {SIP_MLNAME_CAST(sipName_first), meth_QStringList_0_first, METH_VARARGS, SIP_MLDOC_CAST(doc_QStringList_0_first)},
    {SIP_MLNAME_CAST(sipName_indexOf), (PyCFunction)meth_QStringList_0_indexOf, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_indexOf)},
    {SIP_MLNAME_CAST(sipName_insert), (PyCFunction)meth_QStringList_0_insert, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_insert)},
    {SIP_MLNAME_CAST(sipName_isEmpty), meth_QStringList_0_isEmpty, METH_VARARGS, SIP_MLDOC_CAST(doc_QStringList_0_isEmpty)},
    {SIP_MLNAME_CAST(sipName_join), meth_QStringList_0_join, METH_VARARGS, SIP_MLDOC_CAST(doc_QStringList_0_join)},
    {SIP_MLNAME_CAST(sipName_last), meth_QStringList_0_last, METH_VARARGS, SIP_MLDOC_CAST(doc_QStringList_0_last)},
    {SIP_MLNAME_CAST(sipName_lastIndexOf), (PyCFunction)meth_QStringList_0_lastIndexOf, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_lastIndexOf)},
    {SIP_MLNAME_CAST(sipName_mid), (PyCFunction)meth_QStringList_0_mid, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_mid)},
    {SIP_MLNAME_CAST(sipName_move), (PyCFunction)meth_QStringList_0_move, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_move)},
    {SIP_MLNAME_CAST(sipName_prepend), (PyCFunction)meth_QStringList_0_prepend, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_prepend)},
    {SIP_MLNAME_CAST(sipName_removeAll), (PyCFunction)meth_QStringList_0_removeAll, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_removeAll)},
    {SIP_MLNAME_CAST(sipName_removeAt), (PyCFunction)meth_QStringList_0_removeAt, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_removeAt)},
    {SIP_MLNAME_CAST(sipName_removeDuplicates), meth_QStringList_0_removeDuplicates, METH_VARARGS, SIP_MLDOC_CAST(doc_QStringList_0_removeDuplicates)},
    {SIP_MLNAME_CAST(sipName_replace), (PyCFunction)meth_QStringList_0_replace, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_replace)},
    {SIP_MLNAME_CAST(sipName_replaceInStrings), (PyCFunction)meth_QStringList_0_replaceInStrings, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_replaceInStrings)},
    {SIP_MLNAME_CAST(sipName_sort), meth_QStringList_0_sort, METH_VARARGS, SIP_MLDOC_CAST(doc_QStringList_0_sort)},
    {SIP_MLNAME_CAST(sipName_swap), (PyCFunction)meth_QStringList_0_swap, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_swap)},
    {SIP_MLNAME_CAST(sipName_takeAt), (PyCFunction)meth_QStringList_0_takeAt, METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_QStringList_0_takeAt)},
    {SIP_MLNAME_CAST(sipName_takeFirst), meth_QStringList_0_takeFirst, METH_VARARGS, SIP_MLDOC_CAST(doc_QStringList_0_takeFirst)},
    {SIP_MLNAME_CAST(sipName_takeLast), meth_QStringList_0_takeLast, METH_VARARGS, SIP_MLDOC_CAST(doc_QStringList_0_takeLast)}
};

PyDoc_STRVAR(doc_QStringList_0, "\1QStringList()\n"
    "QStringList(QString)\n"
    "QStringList(QStringList)");


pyqt4ClassTypeDef sipTypeDef_QtCore_QStringList_0 = {
{
    {
        0,
        0,
        0,
        SIP_TYPE_CLASS,
        sipNameNr_QStringList,
        {0}
    },
    {
        sipNameNr_QStringList,
        {0, 0, 1},
        25, methods_QStringList_0,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
    },
    doc_QStringList_0,
    sipNameNr_PyQt4_QtCore_pyqtWrapperType,
    sipNameNr_sip_simplewrapper,
    0,
    slots_QStringList_0,
    init_QStringList_0,
    0,
    0,
#if PY_MAJOR_VERSION >= 3
    0,
    0,
#else
    0,
    0,
    0,
    0,
#endif
    dealloc_QStringList_0,
    assign_QStringList_0,
    array_QStringList_0,
    copy_QStringList_0,
    release_QStringList_0,
    cast_QStringList_0,
    convertTo_QStringList_0,
    0,
    0
},
    0,
    0,
    0
};
