/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_path_wrapper.h"

// Extra includes
#include <QList>
#include <effect.h>
#include <medianode.h>
#include <objectdescription.h>
#include <path.h>

using namespace Shiboken;

static int
SbkPhonon_Path_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    Phonon::Path* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "Path", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // Path()
        cptr = new Phonon::Path();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<Phonon::Path & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        Phonon::Path* cpp_arg0 = Shiboken::Converter<Phonon::Path* >::toCpp(pyargs[0]);
        // Path(Phonon::Path)
        cptr = new Phonon::Path(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_Path_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::Path >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkPhonon_Path_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkPhonon_Path_Init_TypeError:
        const char* overloads[] = {"", "PySide.phonon.Phonon::Path", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.Path", overloads);
        return -1;
}

static PyObject* SbkPhonon_PathFunc_disconnectPath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // disconnect()
    Phonon::Path* cppSelf = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->Phonon::Path::disconnect();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_PathFunc_effects(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // effects()const
    Phonon::Path* cppSelf = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)self);
    QList<Phonon::Effect * > cpp_result = cppSelf->Phonon::Path::effects();
    py_result = Shiboken::Converter<QList<Phonon::Effect * > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_PathFunc_insertEffect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertEffect", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<Phonon::EffectDescription & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        Phonon::EffectDescription* cpp_arg0 = Shiboken::Converter<Phonon::EffectDescription* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // insertEffect(Phonon::EffectDescription,Phonon::Effect*)
            Phonon::Path* cppSelf = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)self);
            Phonon::Effect * cpp_result = cppSelf->Phonon::Path::insertEffect(*cpp_arg0);
            py_result = Shiboken::Converter<Phonon::Effect * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, pyargs[0]);
        } else if (Shiboken::Converter<Phonon::Effect * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            Phonon::Effect* cpp_arg1 = Shiboken::Converter<Phonon::Effect* >::toCpp(pyargs[1]);
            // insertEffect(Phonon::EffectDescription,Phonon::Effect*)
            Phonon::Path* cppSelf = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)self);
            Phonon::Effect * cpp_result = cppSelf->Phonon::Path::insertEffect(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<Phonon::Effect * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
            Shiboken::setParent(self, pyargs[0]);
        } else goto SbkPhonon_PathFunc_insertEffect_TypeError;
    } else if (Shiboken::Converter<Phonon::Effect * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        Phonon::Effect* cpp_arg0 = Shiboken::Converter<Phonon::Effect* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // insertEffect(Phonon::Effect*,Phonon::Effect*)
            Phonon::Path* cppSelf = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->Phonon::Path::insertEffect(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[0]);
        } else if (Shiboken::Converter<Phonon::Effect * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            Phonon::Effect* cpp_arg1 = Shiboken::Converter<Phonon::Effect* >::toCpp(pyargs[1]);
            // insertEffect(Phonon::Effect*,Phonon::Effect*)
            Phonon::Path* cppSelf = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->Phonon::Path::insertEffect(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[0]);
        } else goto SbkPhonon_PathFunc_insertEffect_TypeError;
    } else goto SbkPhonon_PathFunc_insertEffect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_PathFunc_insertEffect_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::Effect, PySide.phonon.Phonon::Effect = None", "PySide.phonon.Phonon::EffectDescription, PySide.phonon.Phonon::Effect = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.Path.insertEffect", overloads);
        return 0;
}

static PyObject* SbkPhonon_PathFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    Phonon::Path* cppSelf = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->Phonon::Path::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_PathFunc_reconnect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "reconnect", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<Phonon::MediaNode * >::isConvertible(pyargs[0]) && Shiboken::Converter<Phonon::MediaNode * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        Phonon::MediaNode* cpp_arg0 = Shiboken::Converter<Phonon::MediaNode* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        Phonon::MediaNode* cpp_arg1 = Shiboken::Converter<Phonon::MediaNode* >::toCpp(pyargs[1]);
        // reconnect(Phonon::MediaNode*,Phonon::MediaNode*)
        Phonon::Path* cppSelf = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->Phonon::Path::reconnect(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkPhonon_PathFunc_reconnect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_PathFunc_reconnect_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::MediaNode, PySide.phonon.Phonon::MediaNode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.Path.reconnect", overloads);
        return 0;
}

static PyObject* SbkPhonon_PathFunc_removeEffect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<Phonon::Effect * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        Phonon::Effect* cpp_arg0 = Shiboken::Converter<Phonon::Effect* >::toCpp(arg);
        // removeEffect(Phonon::Effect*)
        Phonon::Path* cppSelf = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->Phonon::Path::removeEffect(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, arg);
    } else goto SbkPhonon_PathFunc_removeEffect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkPhonon_PathFunc_removeEffect_TypeError:
        const char* overloads[] = {"PySide.phonon.Phonon::Effect", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.phonon.Path.removeEffect", overloads);
        return 0;
}

static PyObject* SbkPhonon_PathFunc_sink(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sink()const
    Phonon::Path* cppSelf = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)self);
    Phonon::MediaNode * cpp_result = cppSelf->Phonon::Path::sink();
    py_result = Shiboken::Converter<Phonon::MediaNode * >::toPython(cpp_result);

    // Ownership transferences.
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_PathFunc_source(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // source()const
    Phonon::Path* cppSelf = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)self);
    Phonon::MediaNode * cpp_result = cppSelf->Phonon::Path::source();
    py_result = Shiboken::Converter<Phonon::MediaNode * >::toPython(cpp_result);

    // Ownership transferences.
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkPhonon_Path_methods[] = {
    {"disconnectPath", (PyCFunction)SbkPhonon_PathFunc_disconnectPath, METH_NOARGS},
    {"effects", (PyCFunction)SbkPhonon_PathFunc_effects, METH_NOARGS},
    {"insertEffect", (PyCFunction)SbkPhonon_PathFunc_insertEffect, METH_VARARGS},
    {"isValid", (PyCFunction)SbkPhonon_PathFunc_isValid, METH_NOARGS},
    {"reconnect", (PyCFunction)SbkPhonon_PathFunc_reconnect, METH_VARARGS},
    {"removeEffect", (PyCFunction)SbkPhonon_PathFunc_removeEffect, METH_O},
    {"sink", (PyCFunction)SbkPhonon_PathFunc_sink, METH_NOARGS},
    {"source", (PyCFunction)SbkPhonon_PathFunc_source, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkPhonon_Path_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    Phonon::Path& cpp_self = *Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<Phonon::Path & >::isConvertible(other)) {
                // operator!=(const Phonon::Path & p) const
                Phonon::Path* cpp_other = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<Phonon::Path  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkPhonon_Path_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<Phonon::Path & >::isConvertible(other)) {
                // operator==(const Phonon::Path & p) const
                Phonon::Path* cpp_other = Shiboken::Converter<Phonon::Path* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<Phonon::Path  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkPhonon_Path_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkPhonon_Path_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_Path_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.Path",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkPhonon_Path_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_Path_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_Path_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::Path >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_Phonon_Path(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_PATH_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_Path_Type);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_Path_Type) < 0)
        return;

    PyDict_SetItemString(module,"Path", (PyObject*)&SbkPhonon_Path_Type);
    Shiboken::TypeResolver::createValueTypeResolver<Phonon::Path >("Phonon::Path");
    Shiboken::TypeResolver::createValueTypeResolver<Phonon::Path >(typeid(Phonon::Path).name());
}


} // extern "C"

