/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_phonon_python.h"

#include "phonon_effectparameter_wrapper.h"

// Extra includes
#include <QList>
#include <qstring.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkPhonon_EffectParameter_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    Phonon::EffectParameter* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "EffectParameter", 4, 8, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5]), &(pyargs[6]), &(pyargs[7])))
        return -1;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1]) && SbkPySide_phonon_Phonon_EffectParameter_Hint_Check(pyargs[2]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        QFlags<Phonon::EffectParameter::Hint> cpp_arg2 = Shiboken::Converter<QFlags<Phonon::EffectParameter::Hint> >::toCpp(pyargs[2]);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return -1;
        std::auto_ptr<QVariant > cpp_arg3_auto_ptr;
        QVariant* cpp_arg3 = Shiboken::Converter<QVariant* >::toCpp(pyargs[3]);
        if (!SbkQVariant_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QVariant >(cpp_arg3);
        if (numArgs == 4) {
            // EffectParameter(int,QString,QFlags<Phonon::EffectParameter::Hint>,QVariant,QVariant,QVariant,QList<QVariant>,QString)
            cptr = new Phonon::EffectParameter(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QVariant & >::isConvertible(pyargs[4])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[4]))
                return -1;
            std::auto_ptr<QVariant > cpp_arg4_auto_ptr;
            QVariant* cpp_arg4 = Shiboken::Converter<QVariant* >::toCpp(pyargs[4]);
            if (!SbkQVariant_Check(pyargs[4]))
                cpp_arg4_auto_ptr = std::auto_ptr<QVariant >(cpp_arg4);
            if (numArgs == 5) {
                // EffectParameter(int,QString,QFlags<Phonon::EffectParameter::Hint>,QVariant,QVariant,QVariant,QList<QVariant>,QString)
                cptr = new Phonon::EffectParameter(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4);
                //CppGenerator::writeParentChildManagement
            } else if (Shiboken::Converter<QVariant & >::isConvertible(pyargs[5])) {
                if (Shiboken::cppObjectIsInvalid(pyargs[5]))
                    return -1;
                std::auto_ptr<QVariant > cpp_arg5_auto_ptr;
                QVariant* cpp_arg5 = Shiboken::Converter<QVariant* >::toCpp(pyargs[5]);
                if (!SbkQVariant_Check(pyargs[5]))
                    cpp_arg5_auto_ptr = std::auto_ptr<QVariant >(cpp_arg5);
                if (numArgs == 6) {
                    // EffectParameter(int,QString,QFlags<Phonon::EffectParameter::Hint>,QVariant,QVariant,QVariant,QList<QVariant>,QString)
                    cptr = new Phonon::EffectParameter(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5);
                    //CppGenerator::writeParentChildManagement
                } else if (Shiboken::Converter<QList<QVariant >  >::isConvertible(pyargs[6])) {
                    QList<QVariant >  cpp_arg6 = Shiboken::Converter<QList<QVariant >  >::toCpp(pyargs[6]);
                    if (numArgs == 7) {
                        // EffectParameter(int,QString,QFlags<Phonon::EffectParameter::Hint>,QVariant,QVariant,QVariant,QList<QVariant>,QString)
                        cptr = new Phonon::EffectParameter(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, cpp_arg6);
                        //CppGenerator::writeParentChildManagement
                    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[7])) {
                        if (Shiboken::cppObjectIsInvalid(pyargs[7]))
                            return -1;
                        std::auto_ptr<QString > cpp_arg7_auto_ptr;
                        QString* cpp_arg7 = Shiboken::Converter<QString* >::toCpp(pyargs[7]);
                        if (!SbkQString_Check(pyargs[7]))
                            cpp_arg7_auto_ptr = std::auto_ptr<QString >(cpp_arg7);
                        // EffectParameter(int,QString,QFlags<Phonon::EffectParameter::Hint>,QVariant,QVariant,QVariant,QList<QVariant>,QString)
                        cptr = new Phonon::EffectParameter(cpp_arg0, *cpp_arg1, cpp_arg2, *cpp_arg3, *cpp_arg4, *cpp_arg5, cpp_arg6, *cpp_arg7);
                        //CppGenerator::writeParentChildManagement
                    } else goto SbkPhonon_EffectParameter_Init_TypeError;
                } else goto SbkPhonon_EffectParameter_Init_TypeError;
            } else goto SbkPhonon_EffectParameter_Init_TypeError;
        } else goto SbkPhonon_EffectParameter_Init_TypeError;
    } else goto SbkPhonon_EffectParameter_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<Phonon::EffectParameter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkPhonon_EffectParameter_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkPhonon_EffectParameter_Init_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QString, PySide.phonon.Phonon::EffectParameter.Hints, PySide.QtCore.QVariant, PySide.QtCore.QVariant = QVariant(), PySide.QtCore.QVariant = QVariant(), list = QVariantList(), PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.phonon.EffectParameter", overloads);
        return -1;
}

static PyObject* SbkPhonon_EffectParameterFunc_defaultValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultValue()const
    Phonon::EffectParameter* cppSelf = Shiboken::Converter<Phonon::EffectParameter* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->Phonon::EffectParameter::defaultValue();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_EffectParameterFunc_description(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // description()const
    Phonon::EffectParameter* cppSelf = Shiboken::Converter<Phonon::EffectParameter* >::toCpp((PyObject*)self);
    const QString & cpp_result = cppSelf->Phonon::EffectParameter::description();
    py_result = Shiboken::Converter<QString & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_EffectParameterFunc_isLogarithmicControl(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isLogarithmicControl()const
    Phonon::EffectParameter* cppSelf = Shiboken::Converter<Phonon::EffectParameter* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->Phonon::EffectParameter::isLogarithmicControl();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_EffectParameterFunc_maximumValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // maximumValue()const
    Phonon::EffectParameter* cppSelf = Shiboken::Converter<Phonon::EffectParameter* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->Phonon::EffectParameter::maximumValue();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_EffectParameterFunc_minimumValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // minimumValue()const
    Phonon::EffectParameter* cppSelf = Shiboken::Converter<Phonon::EffectParameter* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->Phonon::EffectParameter::minimumValue();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_EffectParameterFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    Phonon::EffectParameter* cppSelf = Shiboken::Converter<Phonon::EffectParameter* >::toCpp((PyObject*)self);
    const QString & cpp_result = cppSelf->Phonon::EffectParameter::name();
    py_result = Shiboken::Converter<QString & >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_EffectParameterFunc_possibleValues(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // possibleValues()const
    Phonon::EffectParameter* cppSelf = Shiboken::Converter<Phonon::EffectParameter* >::toCpp((PyObject*)self);
    QList<QVariant > cpp_result = cppSelf->Phonon::EffectParameter::possibleValues();
    py_result = Shiboken::Converter<QList<QVariant > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkPhonon_EffectParameterFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    Phonon::EffectParameter* cppSelf = Shiboken::Converter<Phonon::EffectParameter* >::toCpp((PyObject*)self);
    QVariant::Type cpp_result = cppSelf->Phonon::EffectParameter::type();
    py_result = Shiboken::Converter<QVariant::Type >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkPhonon_EffectParameter_methods[] = {
    {"defaultValue", (PyCFunction)SbkPhonon_EffectParameterFunc_defaultValue, METH_NOARGS},
    {"description", (PyCFunction)SbkPhonon_EffectParameterFunc_description, METH_NOARGS},
    {"isLogarithmicControl", (PyCFunction)SbkPhonon_EffectParameterFunc_isLogarithmicControl, METH_NOARGS},
    {"maximumValue", (PyCFunction)SbkPhonon_EffectParameterFunc_maximumValue, METH_NOARGS},
    {"minimumValue", (PyCFunction)SbkPhonon_EffectParameterFunc_minimumValue, METH_NOARGS},
    {"name", (PyCFunction)SbkPhonon_EffectParameterFunc_name, METH_NOARGS},
    {"possibleValues", (PyCFunction)SbkPhonon_EffectParameterFunc_possibleValues, METH_NOARGS},
    {"type", (PyCFunction)SbkPhonon_EffectParameterFunc_type, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkPhonon_EffectParameter_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    Phonon::EffectParameter& cpp_self = *Shiboken::Converter<Phonon::EffectParameter* >::toCpp((PyObject*)self);

    switch (op) {
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkPhonon_EffectParameter_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkPhonon_EffectParameter_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.phonon.EffectParameter",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkPhonon_EffectParameter_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkPhonon_EffectParameter_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkPhonon_EffectParameter_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<Phonon::EffectParameter >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_phonon_Phonon_EffectParameter_Hint___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Phonon::EffectParameter::Hints >::toPython(
        ((Phonon::EffectParameter::Hints) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< Phonon::EffectParameter::Hints >::toCpp(arg)
    );
}

PyObject*
SbkPySide_phonon_Phonon_EffectParameter_Hint___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Phonon::EffectParameter::Hints >::toPython(
        ((Phonon::EffectParameter::Hints) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< Phonon::EffectParameter::Hints >::toCpp(arg)
    );
}

PyObject*
SbkPySide_phonon_Phonon_EffectParameter_Hint___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Phonon::EffectParameter::Hints >::toPython(
        ((Phonon::EffectParameter::Hints) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< Phonon::EffectParameter::Hints >::toCpp(arg)
    );
}

PyObject*
SbkPySide_phonon_Phonon_EffectParameter_Hint___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< Phonon::EffectParameter::Hints >::toPython(
        ~ Shiboken::Converter< Phonon::EffectParameter::Hints >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_phonon_Phonon_EffectParameter_Hint_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_phonon_Phonon_EffectParameter_Hint___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_phonon_Phonon_EffectParameter_Hint___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_phonon_Phonon_EffectParameter_Hint___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_phonon_Phonon_EffectParameter_Hint___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_phonon_Phonon_EffectParameter_Hint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_EffectParameter_Hint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_EffectParameter_Hint_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Hint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_phonon_Phonon_EffectParameter_Hint_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_phonon_Phonon_EffectParameter_Hint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_EffectParameter_Hint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_EffectParameter_Hint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_phonon_Phonon_EffectParameter_Hints_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_phonon_Phonon_EffectParameter_Hints_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Hints",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_phonon_Phonon_EffectParameter_Hint_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_phonon_Phonon_EffectParameter_Hints_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_phonon_Phonon_EffectParameter_Hints_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_phonon_Phonon_EffectParameter_Hints_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_Phonon_EffectParameter(PyObject* module)
{
    SbkPySide_phononTypes[SBK_PHONON_EFFECTPARAMETER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkPhonon_EffectParameter_Type);

    if (PyType_Ready((PyTypeObject*)&SbkPhonon_EffectParameter_Type) < 0)
        return;

    PyDict_SetItemString(module,"EffectParameter", (PyObject*)&SbkPhonon_EffectParameter_Type);
    // Initialize enums
    PyObject* enum_item;

    // init enum class: Hint
    SbkPySide_phononTypes[SBK_PHONON_EFFECTPARAMETER_HINT_IDX] = &SbkPySide_phonon_Phonon_EffectParameter_Hint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_EffectParameter_Hint_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_EffectParameter_Hint_Type);
    PyDict_SetItemString(SbkPhonon_EffectParameter_Type.super.ht_type.tp_dict,
            "Hint",((PyObject*)&SbkPySide_phonon_Phonon_EffectParameter_Hint_Type));

    // init flags class: QFlags<Phonon::EffectParameter::Hint>
    SbkPySide_phononTypes[SBK_QFLAGS_PHONON_EFFECTPARAMETER_HINT__IDX] = &SbkPySide_phonon_Phonon_EffectParameter_Hints_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_phonon_Phonon_EffectParameter_Hints_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_phonon_Phonon_EffectParameter_Hints_Type);
    PyDict_SetItemString(SbkPhonon_EffectParameter_Type.super.ht_type.tp_dict,
            "Hints",((PyObject*)&SbkPySide_phonon_Phonon_EffectParameter_Hints_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_EffectParameter_Hint_Type,
        (long) Phonon::EffectParameter::ToggledHint, "ToggledHint");
    PyDict_SetItemString(SbkPhonon_EffectParameter_Type.super.ht_type.tp_dict,
        "ToggledHint", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_EffectParameter_Hint_Type.tp_dict,
        "ToggledHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_EffectParameter_Hint_Type,
        (long) Phonon::EffectParameter::LogarithmicHint, "LogarithmicHint");
    PyDict_SetItemString(SbkPhonon_EffectParameter_Type.super.ht_type.tp_dict,
        "LogarithmicHint", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_EffectParameter_Hint_Type.tp_dict,
        "LogarithmicHint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_phonon_Phonon_EffectParameter_Hint_Type,
        (long) Phonon::EffectParameter::IntegerHint, "IntegerHint");
    PyDict_SetItemString(SbkPhonon_EffectParameter_Type.super.ht_type.tp_dict,
        "IntegerHint", enum_item);
    PyDict_SetItemString(SbkPySide_phonon_Phonon_EffectParameter_Hint_Type.tp_dict,
        "IntegerHint", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("Phonon::EffectParameter::Hint");

    Shiboken::TypeResolver::createValueTypeResolver<Phonon::EffectParameter >("Phonon::EffectParameter");
    Shiboken::TypeResolver::createValueTypeResolver<Phonon::EffectParameter >(typeid(Phonon::EffectParameter).name());
}


} // extern "C"

