/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxmlpatterns_python.h"

#include "qxmlnodemodelindex_wrapper.h"

// Extra includes
#include <qabstractxmlnodemodel.h>

using namespace Shiboken;

static int
SbkQXmlNodeModelIndex_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlNodeModelIndex* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QXmlNodeModelIndex", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QXmlNodeModelIndex()
        cptr = new QXmlNodeModelIndex();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(pyargs[0]);
        // QXmlNodeModelIndex(QXmlNodeModelIndex)
        cptr = new QXmlNodeModelIndex(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlNodeModelIndex_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QXmlNodeModelIndex >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlNodeModelIndex_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQXmlNodeModelIndex_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlNodeModelIndex", overloads);
        return -1;
}

static PyObject* SbkQXmlNodeModelIndexFunc_additionalData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // additionalData()const
    QXmlNodeModelIndex* cppSelf = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QXmlNodeModelIndex::additionalData();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlNodeModelIndexFunc_data(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // data()const
    QXmlNodeModelIndex* cppSelf = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QXmlNodeModelIndex::data();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlNodeModelIndexFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QXmlNodeModelIndex* cppSelf = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QXmlNodeModelIndex::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlNodeModelIndexFunc_model(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // model()const
    QXmlNodeModelIndex* cppSelf = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp((PyObject*)self);
    const QAbstractXmlNodeModel * cpp_result = cppSelf->QXmlNodeModelIndex::model();
    py_result = Shiboken::Converter<QAbstractXmlNodeModel * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQXmlNodeModelIndex_methods[] = {
    {"additionalData", (PyCFunction)SbkQXmlNodeModelIndexFunc_additionalData, METH_NOARGS},
    {"data", (PyCFunction)SbkQXmlNodeModelIndexFunc_data, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQXmlNodeModelIndexFunc_isNull, METH_NOARGS},
    {"model", (PyCFunction)SbkQXmlNodeModelIndexFunc_model, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQXmlNodeModelIndex_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QXmlNodeModelIndex& cpp_self = *Shiboken::Converter<QXmlNodeModelIndex* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(other)) {
                // operator!=(const QXmlNodeModelIndex & other) const
                QXmlNodeModelIndex* cpp_other = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QXmlNodeModelIndex  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQXmlNodeModelIndex_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(other)) {
                // operator==(const QXmlNodeModelIndex & other) const
                QXmlNodeModelIndex* cpp_other = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QXmlNodeModelIndex  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQXmlNodeModelIndex_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQXmlNodeModelIndex_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlNodeModelIndex_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXmlPatterns.QXmlNodeModelIndex",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQXmlNodeModelIndex_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlNodeModelIndex_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlNodeModelIndex_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QXmlNodeModelIndex >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NodeKind",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "DocumentOrder",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Axis",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QXmlNodeModelIndex(PyObject* module)
{
    SbkPySide_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlNodeModelIndex_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlNodeModelIndex_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlNodeModelIndex_Type));
    PyModule_AddObject(module, "QXmlNodeModelIndex",
        ((PyObject*)&SbkQXmlNodeModelIndex_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: NodeKind
    SbkPySide_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX] = &SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type);
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
            "NodeKind",((PyObject*)&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type,
        (long) QXmlNodeModelIndex::Attribute, "Attribute");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "Attribute", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type.tp_dict,
        "Attribute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type,
        (long) QXmlNodeModelIndex::Comment, "Comment");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "Comment", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type.tp_dict,
        "Comment", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type,
        (long) QXmlNodeModelIndex::Document, "Document");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "Document", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type.tp_dict,
        "Document", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type,
        (long) QXmlNodeModelIndex::Element, "Element");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "Element", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type.tp_dict,
        "Element", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type,
        (long) QXmlNodeModelIndex::Namespace, "Namespace");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "Namespace", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type.tp_dict,
        "Namespace", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type,
        (long) QXmlNodeModelIndex::ProcessingInstruction, "ProcessingInstruction");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "ProcessingInstruction", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type.tp_dict,
        "ProcessingInstruction", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type,
        (long) QXmlNodeModelIndex::Text, "Text");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "Text", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Type.tp_dict,
        "Text", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QXmlNodeModelIndex::NodeKind");

    // init enum class: DocumentOrder
    SbkPySide_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX] = &SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_Type);
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
            "DocumentOrder",((PyObject*)&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_Type,
        (long) QXmlNodeModelIndex::Precedes, "Precedes");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "Precedes", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_Type.tp_dict,
        "Precedes", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_Type,
        (long) QXmlNodeModelIndex::Is, "Is");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "Is", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_Type.tp_dict,
        "Is", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_Type,
        (long) QXmlNodeModelIndex::Follows, "Follows");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "Follows", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_Type.tp_dict,
        "Follows", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QXmlNodeModelIndex::DocumentOrder");

    // init enum class: Axis
    SbkPySide_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_AXIS_IDX] = &SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type);
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
            "Axis",((PyObject*)&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisChild, "AxisChild");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisChild", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisChild", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisDescendant, "AxisDescendant");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisDescendant", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisDescendant", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisAttribute, "AxisAttribute");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisAttribute", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisAttribute", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisSelf, "AxisSelf");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisSelf", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisSelf", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisDescendantOrSelf, "AxisDescendantOrSelf");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisDescendantOrSelf", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisDescendantOrSelf", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisFollowingSibling, "AxisFollowingSibling");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisFollowingSibling", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisFollowingSibling", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisNamespace, "AxisNamespace");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisNamespace", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisNamespace", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisFollowing, "AxisFollowing");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisFollowing", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisFollowing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisParent, "AxisParent");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisParent", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisParent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisAncestor, "AxisAncestor");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisAncestor", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisAncestor", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisPrecedingSibling, "AxisPrecedingSibling");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisPrecedingSibling", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisPrecedingSibling", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisPreceding, "AxisPreceding");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisPreceding", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisPreceding", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisAncestorOrSelf, "AxisAncestorOrSelf");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisAncestorOrSelf", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisAncestorOrSelf", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisChildOrTop, "AxisChildOrTop");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisChildOrTop", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisChildOrTop", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type,
        (long) QXmlNodeModelIndex::AxisAttributeOrTop, "AxisAttributeOrTop");
    PyDict_SetItemString(SbkQXmlNodeModelIndex_Type.super.ht_type.tp_dict,
        "AxisAttributeOrTop", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Type.tp_dict,
        "AxisAttributeOrTop", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QXmlNodeModelIndex::Axis");

    Shiboken::TypeResolver::createValueTypeResolver<QXmlNodeModelIndex >("QXmlNodeModelIndex");
    Shiboken::TypeResolver::createValueTypeResolver<QXmlNodeModelIndex >(typeid(QXmlNodeModelIndex).name());
}


} // extern "C"

