/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxml_python.h"

#include "qxmlattributes_wrapper.h"

// Extra includes
#include <qstring.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QXmlAttributesWrapper::QXmlAttributesWrapper() : QXmlAttributes() {
    // ... middle
}

QXmlAttributesWrapper::~QXmlAttributesWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQXmlAttributes_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlAttributesWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QXmlAttributes", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QXmlAttributes()
        cptr = new QXmlAttributesWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QXmlAttributes & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QXmlAttributes* cpp_arg0 = Shiboken::Converter<QXmlAttributes* >::toCpp(pyargs[0]);
        // QXmlAttributes(QXmlAttributes)
        cptr = new QXmlAttributesWrapper(*reinterpret_cast<QXmlAttributesWrapper*>(cpp_arg0));
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlAttributes_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QXmlAttributes >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlAttributes_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQXmlAttributes_Init_TypeError:
        const char* overloads[] = {"PySide.QtXml.QXmlAttributes", "", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlAttributes", overloads);
        return -1;
}

static PyObject* SbkQXmlAttributesFunc_append(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "append", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1]) && Shiboken::Converter<QString & >::isConvertible(pyargs[2]) && Shiboken::Converter<QString & >::isConvertible(pyargs[3])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QString > cpp_arg2_auto_ptr;
        QString* cpp_arg2 = Shiboken::Converter<QString* >::toCpp(pyargs[2]);
        if (!SbkQString_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QString >(cpp_arg2);
        if (Shiboken::cppObjectIsInvalid(pyargs[3]))
            return 0;
        std::auto_ptr<QString > cpp_arg3_auto_ptr;
        QString* cpp_arg3 = Shiboken::Converter<QString* >::toCpp(pyargs[3]);
        if (!SbkQString_Check(pyargs[3]))
            cpp_arg3_auto_ptr = std::auto_ptr<QString >(cpp_arg3);
        // append(QString,QString,QString,QString)
        QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
        cppSelf->QXmlAttributes::append(*cpp_arg0, *cpp_arg1, *cpp_arg2, *cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlAttributesFunc_append_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlAttributesFunc_append_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlAttributes.append", overloads);
        return 0;
}

static PyObject* SbkQXmlAttributesFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
    cppSelf->QXmlAttributes::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQXmlAttributesFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QXmlAttributes::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlAttributesFunc_index(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "index", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QLatin1String & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QLatin1String* cpp_arg0 = Shiboken::Converter<QLatin1String* >::toCpp(pyargs[0]);
        // index(QLatin1String)const
        QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QXmlAttributes::index(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // index(QString)const
            QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QXmlAttributes::index(*cpp_arg0);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // index(QString,QString)const
            QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QXmlAttributes::index(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlAttributesFunc_index_TypeError;
    } else goto SbkQXmlAttributesFunc_index_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlAttributesFunc_index_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLatin1String", "PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlAttributes.index", overloads);
        return 0;
}

static PyObject* SbkQXmlAttributesFunc_length(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // length()const
    QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QXmlAttributes::length();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlAttributesFunc_localName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // localName(int)const
        QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlAttributes::localName(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlAttributesFunc_localName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlAttributesFunc_localName_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlAttributes.localName", overloads);
        return 0;
}

static PyObject* SbkQXmlAttributesFunc_qName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // qName(int)const
        QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlAttributes::qName(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlAttributesFunc_qName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlAttributesFunc_qName_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlAttributes.qName", overloads);
        return 0;
}

static PyObject* SbkQXmlAttributesFunc_type(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "type", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // type(int)const
        QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlAttributes::type(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // type(QString)const
            QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QXmlAttributes::type(*cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // type(QString,QString)const
            QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QXmlAttributes::type(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlAttributesFunc_type_TypeError;
    } else goto SbkQXmlAttributesFunc_type_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlAttributesFunc_type_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QString", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlAttributes.type", overloads);
        return 0;
}

static PyObject* SbkQXmlAttributesFunc_uri(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // uri(int)const
        QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlAttributes::uri(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlAttributesFunc_uri_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlAttributesFunc_uri_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXml.QXmlAttributes.uri", overloads);
        return 0;
}

static PyObject* SbkQXmlAttributesFunc_value(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "value", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        // value(int)const
        QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlAttributes::value(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QLatin1String & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QLatin1String* cpp_arg0 = Shiboken::Converter<QLatin1String* >::toCpp(pyargs[0]);
        // value(QLatin1String)const
        QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QXmlAttributes::value(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // value(QString)const
            QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QXmlAttributes::value(*cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // value(QString,QString)const
            QXmlAttributes* cppSelf = Shiboken::Converter<QXmlAttributes* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QXmlAttributes::value(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlAttributesFunc_value_TypeError;
    } else goto SbkQXmlAttributesFunc_value_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlAttributesFunc_value_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLatin1String", "PySide.QtCore.QString", "PySide.QtCore.QString, PySide.QtCore.QString", "int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXml.QXmlAttributes.value", overloads);
        return 0;
}

static PyMethodDef SbkQXmlAttributes_methods[] = {
    {"append", (PyCFunction)SbkQXmlAttributesFunc_append, METH_VARARGS},
    {"clear", (PyCFunction)SbkQXmlAttributesFunc_clear, METH_NOARGS},
    {"count", (PyCFunction)SbkQXmlAttributesFunc_count, METH_NOARGS},
    {"index", (PyCFunction)SbkQXmlAttributesFunc_index, METH_VARARGS},
    {"length", (PyCFunction)SbkQXmlAttributesFunc_length, METH_NOARGS},
    {"localName", (PyCFunction)SbkQXmlAttributesFunc_localName, METH_O},
    {"qName", (PyCFunction)SbkQXmlAttributesFunc_qName, METH_O},
    {"type", (PyCFunction)SbkQXmlAttributesFunc_type, METH_VARARGS},
    {"uri", (PyCFunction)SbkQXmlAttributesFunc_uri, METH_O},
    {"value", (PyCFunction)SbkQXmlAttributesFunc_value, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQXmlAttributes_ObjCopierFunc(const void* ptr){
    return new QXmlAttributesWrapper(*reinterpret_cast<const QXmlAttributes*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlAttributes_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXml.QXmlAttributes",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlAttributes_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlAttributes_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQXmlAttributes_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QXmlAttributes >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQXmlAttributes_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQXmlAttributes_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QXmlAttributes*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}


PyAPI_FUNC(void) init_QXmlAttributes(PyObject* module)
{
    SbkPySide_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlAttributes_Type);

    // Fill type discovery information
    SbkQXmlAttributes_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQXmlAttributes_Type.type_discovery->addTypeDiscoveryFunction(&SbkQXmlAttributes_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlAttributes_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlAttributes_Type));
    PyModule_AddObject(module, "QXmlAttributes",
        ((PyObject*)&SbkQXmlAttributes_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QXmlAttributes >("QXmlAttributes");
    Shiboken::TypeResolver::createValueTypeResolver<QXmlAttributes >(typeid(QXmlAttributes).name());
}


} // extern "C"

