/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtwebkit_python.h"

#include "qwebhistoryitem_wrapper.h"

// Extra includes
#include <qdatetime.h>
#include <qicon.h>
#include <qstring.h>
#include <qurl.h>
#include <qvariant.h>
#include <qwebhistory.h>

using namespace Shiboken;

static int
SbkQWebHistoryItem_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWebHistoryItem* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QWebHistoryItem", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<QWebHistoryItem & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWebHistoryItem* cpp_arg0 = Shiboken::Converter<QWebHistoryItem* >::toCpp(pyargs[0]);
        // QWebHistoryItem(QWebHistoryItem)
        cptr = new QWebHistoryItem(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebHistoryItem_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QWebHistoryItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWebHistoryItem_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQWebHistoryItem_Init_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebHistoryItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebHistoryItem", overloads);
        return -1;
}

static PyObject* SbkQWebHistoryItemFunc_icon(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // icon()const
    QWebHistoryItem* cppSelf = Shiboken::Converter<QWebHistoryItem* >::toCpp((PyObject*)self);
    QIcon cpp_result = cppSelf->QWebHistoryItem::icon();
    py_result = Shiboken::Converter<QIcon >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHistoryItemFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QWebHistoryItem* cppSelf = Shiboken::Converter<QWebHistoryItem* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QWebHistoryItem::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHistoryItemFunc_lastVisited(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastVisited()const
    QWebHistoryItem* cppSelf = Shiboken::Converter<QWebHistoryItem* >::toCpp((PyObject*)self);
    QDateTime cpp_result = cppSelf->QWebHistoryItem::lastVisited();
    py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHistoryItemFunc_originalUrl(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // originalUrl()const
    QWebHistoryItem* cppSelf = Shiboken::Converter<QWebHistoryItem* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QWebHistoryItem::originalUrl();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHistoryItemFunc_setUserData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVariant & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(arg);
        if (!SbkQVariant_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // setUserData(QVariant)
        QWebHistoryItem* cppSelf = Shiboken::Converter<QWebHistoryItem* >::toCpp((PyObject*)self);
        cppSelf->QWebHistoryItem::setUserData(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebHistoryItemFunc_setUserData_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebHistoryItemFunc_setUserData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebHistoryItem.setUserData", overloads);
        return 0;
}

static PyObject* SbkQWebHistoryItemFunc_title(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // title()const
    QWebHistoryItem* cppSelf = Shiboken::Converter<QWebHistoryItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QWebHistoryItem::title();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHistoryItemFunc_url(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // url()const
    QWebHistoryItem* cppSelf = Shiboken::Converter<QWebHistoryItem* >::toCpp((PyObject*)self);
    QUrl cpp_result = cppSelf->QWebHistoryItem::url();
    py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebHistoryItemFunc_userData(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // userData()const
    QWebHistoryItem* cppSelf = Shiboken::Converter<QWebHistoryItem* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QWebHistoryItem::userData();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQWebHistoryItem_methods[] = {
    {"icon", (PyCFunction)SbkQWebHistoryItemFunc_icon, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQWebHistoryItemFunc_isValid, METH_NOARGS},
    {"lastVisited", (PyCFunction)SbkQWebHistoryItemFunc_lastVisited, METH_NOARGS},
    {"originalUrl", (PyCFunction)SbkQWebHistoryItemFunc_originalUrl, METH_NOARGS},
    {"setUserData", (PyCFunction)SbkQWebHistoryItemFunc_setUserData, METH_O},
    {"title", (PyCFunction)SbkQWebHistoryItemFunc_title, METH_NOARGS},
    {"url", (PyCFunction)SbkQWebHistoryItemFunc_url, METH_NOARGS},
    {"userData", (PyCFunction)SbkQWebHistoryItemFunc_userData, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebHistoryItem_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.QWebHistoryItem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebHistoryItem_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWebHistoryItem_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QWebHistoryItem >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QWebHistoryItem(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBHISTORYITEM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebHistoryItem_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQWebHistoryItem_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWebHistoryItem_Type));
    PyModule_AddObject(module, "QWebHistoryItem",
        ((PyObject*)&SbkQWebHistoryItem_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QWebHistoryItem >("QWebHistoryItem");
    Shiboken::TypeResolver::createValueTypeResolver<QWebHistoryItem >(typeid(QWebHistoryItem).name());
}


} // extern "C"

