/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtwebkit_python.h"

#include "qwebelementcollection_wrapper.h"

// Extra includes
#include <QList>
#include <qstring.h>
#include <qwebelement.h>

using namespace Shiboken;

static int
SbkQWebElementCollection_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QWebElementCollection* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QWebElementCollection", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QWebElementCollection()
        cptr = new QWebElementCollection();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QWebElementCollection & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWebElementCollection* cpp_arg0 = Shiboken::Converter<QWebElementCollection* >::toCpp(pyargs[0]);
        // QWebElementCollection(QWebElementCollection)
        cptr = new QWebElementCollection(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QWebElement & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QWebElement* cpp_arg0 = Shiboken::Converter<QWebElement* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // QWebElementCollection(QWebElement,QString)
        cptr = new QWebElementCollection(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementCollection_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QWebElementCollection >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQWebElementCollection_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQWebElementCollection_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtWebKit.QWebElement, PySide.QtCore.QString", "PySide.QtWebKit.QWebElementCollection", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtWebKit.QWebElementCollection", overloads);
        return -1;
}

static PyObject* SbkQWebElementCollectionFunc_append(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWebElementCollection & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebElementCollection* cpp_arg0 = Shiboken::Converter<QWebElementCollection* >::toCpp(arg);
        // append(QWebElementCollection)
        QWebElementCollection* cppSelf = Shiboken::Converter<QWebElementCollection* >::toCpp((PyObject*)self);
        cppSelf->QWebElementCollection::append(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementCollectionFunc_append_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQWebElementCollectionFunc_append_TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebElementCollection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElementCollection.append", overloads);
        return 0;
}

static PyObject* SbkQWebElementCollectionFunc_at(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // at(int)const
        QWebElementCollection* cppSelf = Shiboken::Converter<QWebElementCollection* >::toCpp((PyObject*)self);
        QWebElement cpp_result = cppSelf->QWebElementCollection::at(cpp_arg0);
        py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementCollectionFunc_at_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebElementCollectionFunc_at_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElementCollection.at", overloads);
        return 0;
}

static PyObject* SbkQWebElementCollectionFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QWebElementCollection* cppSelf = Shiboken::Converter<QWebElementCollection* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QWebElementCollection::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementCollectionFunc_first(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // first()const
    QWebElementCollection* cppSelf = Shiboken::Converter<QWebElementCollection* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebElementCollection::first();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementCollectionFunc_last(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // last()const
    QWebElementCollection* cppSelf = Shiboken::Converter<QWebElementCollection* >::toCpp((PyObject*)self);
    QWebElement cpp_result = cppSelf->QWebElementCollection::last();
    py_result = Shiboken::Converter<QWebElement >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQWebElementCollectionFunc_toList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toList()const
    QWebElementCollection* cppSelf = Shiboken::Converter<QWebElementCollection* >::toCpp((PyObject*)self);
    QList<QWebElement > cpp_result = cppSelf->QWebElementCollection::toList();
    py_result = Shiboken::Converter<QList<QWebElement > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQWebElementCollection_methods[] = {
    {"append", (PyCFunction)SbkQWebElementCollectionFunc_append, METH_O},
    {"at", (PyCFunction)SbkQWebElementCollectionFunc_at, METH_O},
    {"count", (PyCFunction)SbkQWebElementCollectionFunc_count, METH_NOARGS},
    {"first", (PyCFunction)SbkQWebElementCollectionFunc_first, METH_NOARGS},
    {"last", (PyCFunction)SbkQWebElementCollectionFunc_last, METH_NOARGS},
    {"toList", (PyCFunction)SbkQWebElementCollectionFunc_toList, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQWebElementCollectionFunc___add__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQWebElementCollection_Check(arg) && !SbkQWebElementCollection_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__radd__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__radd__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QWebElementCollection & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebElementCollection* cpp_arg0 = Shiboken::Converter<QWebElementCollection* >::toCpp(arg);
        // operator+(QWebElementCollection)const
        QWebElementCollection* cppSelf = Shiboken::Converter<QWebElementCollection* >::toCpp((PyObject*)self);
        QWebElementCollection cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QWebElementCollection >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementCollectionFunc___add___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQWebElementCollectionFunc___add___TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebElementCollection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElementCollection.__add__", overloads);
        return 0;
}

static PyObject* SbkQWebElementCollectionFunc___iadd__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQWebElementCollection_Check(arg) && !SbkQWebElementCollection_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QWebElementCollection & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWebElementCollection* cpp_arg0 = Shiboken::Converter<QWebElementCollection* >::toCpp(arg);
        // operator+=(QWebElementCollection)
        QWebElementCollection* cppSelf = Shiboken::Converter<QWebElementCollection* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQWebElementCollectionFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQWebElementCollectionFunc___iadd___TypeError:
        const char* overloads[] = {"PySide.QtWebKit.QWebElementCollection", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtWebKit.QWebElementCollection.__iadd__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQWebElementCollection_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQWebElementCollectionFunc___add__,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQWebElementCollectionFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQWebElementCollection_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtWebKit.QWebElementCollection",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQWebElementCollection_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQWebElementCollection_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQWebElementCollection_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QWebElementCollection >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QWebElementCollection(PyObject* module)
{
    SbkPySide_QtWebKitTypes[SBK_QWEBELEMENTCOLLECTION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQWebElementCollection_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQWebElementCollection_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQWebElementCollection_Type));
    PyModule_AddObject(module, "QWebElementCollection",
        ((PyObject*)&SbkQWebElementCollection_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QWebElementCollection >("QWebElementCollection");
    Shiboken::TypeResolver::createValueTypeResolver<QWebElementCollection >(typeid(QWebElementCollection).name());
}


} // extern "C"

