/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtscript_python.h"

#include "qscriptengine_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatetime.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qregexp.h>
#include <qscriptclass.h>
#include <qscriptcontext.h>
#include <qscriptengine.h>
#include <qscriptengineagent.h>
#include <qscriptprogram.h>
#include <qscriptstring.h>
#include <qscriptvalue.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QScriptEngineWrapper::QScriptEngineWrapper() : QScriptEngine(), m_metaObject(0) {
    // ... middle
}

QScriptEngineWrapper::QScriptEngineWrapper(QObject * parent) : QScriptEngine(parent), m_metaObject(0) {
    // ... middle
}

void QScriptEngineWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QScriptEngineWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QScriptEngineWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QScriptEngineWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QScriptEngineWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptEngine.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QScriptEngineWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QScriptEngine.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QScriptEngineWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QScriptEngineWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QScriptEngine::staticMetaObject);
}
    return m_metaObject;
}

int QScriptEngineWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QScriptEngine::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QScriptEngineWrapper::~QScriptEngineWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQScriptEngine_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QScriptEngineWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QScriptEngine", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QScriptEngine()
        cptr = new QScriptEngineWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QScriptEngine(QObject*)
        cptr = new QScriptEngineWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQScriptEngine_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QScriptEngine >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQScriptEngine_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQScriptEngine_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptEngine", overloads);
        return -1;
}

static PyObject* SbkQScriptEngineFunc_abortEvaluation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // abortEvaluation(QScriptValue)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        cppSelf->QScriptEngine::abortEvaluation();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // abortEvaluation(QScriptValue)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        cppSelf->QScriptEngine::abortEvaluation(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_abortEvaluation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptEngineFunc_abortEvaluation_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue = QScriptValue()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.abortEvaluation", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_agent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // agent()const
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    QScriptEngineAgent * cpp_result = cppSelf->QScriptEngine::agent();
    py_result = Shiboken::Converter<QScriptEngineAgent * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_availableExtensions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // availableExtensions()const
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QScriptEngine::availableExtensions();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_canEvaluate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // canEvaluate(QString)const
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QScriptEngine::canEvaluate(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_canEvaluate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_canEvaluate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.canEvaluate", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_clearExceptions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearExceptions()
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    cppSelf->QScriptEngine::clearExceptions();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQScriptEngineFunc_collectGarbage(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // collectGarbage()
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    cppSelf->QScriptEngine::collectGarbage();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQScriptEngineFunc_currentContext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentContext()const
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    QScriptContext * cpp_result = cppSelf->QScriptEngine::currentContext();
    py_result = Shiboken::Converter<QScriptContext * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_defaultPrototype(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // defaultPrototype(int)const
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::defaultPrototype(cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_defaultPrototype_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_defaultPrototype_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.defaultPrototype", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_evaluate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "evaluate", 1, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // evaluate(QString,QString,int)
            QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
            QScriptValue cpp_result = cppSelf->QScriptEngine::evaluate(*cpp_arg0);
            py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // evaluate(QString,QString,int)
                QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
                QScriptValue cpp_result = cppSelf->QScriptEngine::evaluate(*cpp_arg0, *cpp_arg1);
                py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // evaluate(QString,QString,int)
                QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
                QScriptValue cpp_result = cppSelf->QScriptEngine::evaluate(*cpp_arg0, *cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQScriptEngineFunc_evaluate_TypeError;
        } else goto SbkQScriptEngineFunc_evaluate_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QScriptProgram & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QScriptProgram* cpp_arg0 = Shiboken::Converter<QScriptProgram* >::toCpp(pyargs[0]);
        // evaluate(QScriptProgram)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::evaluate(*cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_evaluate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_evaluate_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptProgram", "PySide.QtCore.QString, PySide.QtCore.QString = QString(), int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptEngine.evaluate", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_globalObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalObject()const
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptEngine::globalObject();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_hasUncaughtException(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasUncaughtException()const
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptEngine::hasUncaughtException();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_importExtension(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // importExtension(QString)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::importExtension(*cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_importExtension_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_importExtension_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.importExtension", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_importedExtensions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // importedExtensions()const
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QScriptEngine::importedExtensions();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_installTranslatorFunctions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // installTranslatorFunctions(QScriptValue)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        cppSelf->QScriptEngine::installTranslatorFunctions();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // installTranslatorFunctions(QScriptValue)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        cppSelf->QScriptEngine::installTranslatorFunctions(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_installTranslatorFunctions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptEngineFunc_installTranslatorFunctions_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue = QScriptValue()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.installTranslatorFunctions", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_isEvaluating(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEvaluating()const
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptEngine::isEvaluating();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_newActivationObject(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // newActivationObject()
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptEngine::newActivationObject();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_newArray(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // newArray(uint)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::newArray();
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        uint cpp_arg0 = Shiboken::Converter<uint >::toCpp(arg);
        // newArray(uint)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::newArray(cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_newArray_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_newArray_TypeError:
        const char* overloads[] = {"unsigned int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.newArray", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_newDate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        double cpp_arg0 = Shiboken::Converter<double >::toCpp(arg);
        // newDate(double)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::newDate(cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QDateTime & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDateTime* cpp_arg0 = Shiboken::Converter<QDateTime* >::toCpp(arg);
        // newDate(QDateTime)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::newDate(*cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_newDate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_newDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDateTime", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.newDate", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_newObject(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "newObject", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // newObject()
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::newObject();
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QScriptClass * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QScriptClass* cpp_arg0 = Shiboken::Converter<QScriptClass* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // newObject(QScriptClass*,QScriptValue)
            QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
            QScriptValue cpp_result = cppSelf->QScriptEngine::newObject(cpp_arg0);
            py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QScriptValue > cpp_arg1_auto_ptr;
            QScriptValue* cpp_arg1 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[1]);
            if (!SbkQScriptValue_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg1);
            // newObject(QScriptClass*,QScriptValue)
            QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
            QScriptValue cpp_result = cppSelf->QScriptEngine::newObject(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQScriptEngineFunc_newObject_TypeError;
    } else goto SbkQScriptEngineFunc_newObject_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_newObject_TypeError:
        const char* overloads[] = {"", "PySide.QtScript.QScriptClass, PySide.QtScript.QScriptValue = QScriptValue()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptEngine.newObject", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_newQMetaObject(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "newQMetaObject", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QMetaObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMetaObject* cpp_arg0 = Shiboken::Converter<QMetaObject* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // newQMetaObject(const QMetaObject*,QScriptValue)
            QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
            QScriptValue cpp_result = cppSelf->QScriptEngine::newQMetaObject(cpp_arg0);
            py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QScriptValue > cpp_arg1_auto_ptr;
            QScriptValue* cpp_arg1 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[1]);
            if (!SbkQScriptValue_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg1);
            // newQMetaObject(const QMetaObject*,QScriptValue)
            QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
            QScriptValue cpp_result = cppSelf->QScriptEngine::newQMetaObject(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQScriptEngineFunc_newQMetaObject_TypeError;
    } else goto SbkQScriptEngineFunc_newQMetaObject_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_newQMetaObject_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMetaObject, PySide.QtScript.QScriptValue = QScriptValue()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptEngine.newQMetaObject", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_newQObject(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "newQObject", 1, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[0]) && Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[0]);
        if (!SbkQScriptValue_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // newQObject(QScriptValue,QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
            QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
            QScriptValue cpp_result = cppSelf->QScriptEngine::newQObject(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QScriptEngine::ValueOwnership >::isConvertible(pyargs[2])) {
            QScriptEngine::ValueOwnership cpp_arg2 = Shiboken::Converter<QScriptEngine::ValueOwnership >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // newQObject(QScriptValue,QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
                QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
                QScriptValue cpp_result = cppSelf->QScriptEngine::newQObject(*cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Check(pyargs[3])) {
                const QFlags<QScriptEngine::QObjectWrapOption> & cpp_arg3 = Shiboken::Converter<const QFlags<QScriptEngine::QObjectWrapOption> & >::toCpp(pyargs[3]);
                // newQObject(QScriptValue,QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
                QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
                QScriptValue cpp_result = cppSelf->QScriptEngine::newQObject(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQScriptEngineFunc_newQObject_TypeError;
        } else goto SbkQScriptEngineFunc_newQObject_TypeError;
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // newQObject(QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
            QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
            QScriptValue cpp_result = cppSelf->QScriptEngine::newQObject(cpp_arg0);
            py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QScriptEngine::ValueOwnership >::isConvertible(pyargs[1])) {
            QScriptEngine::ValueOwnership cpp_arg1 = Shiboken::Converter<QScriptEngine::ValueOwnership >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // newQObject(QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
                QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
                QScriptValue cpp_result = cppSelf->QScriptEngine::newQObject(cpp_arg0, cpp_arg1);
                py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else if (SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Check(pyargs[2])) {
                const QFlags<QScriptEngine::QObjectWrapOption> & cpp_arg2 = Shiboken::Converter<const QFlags<QScriptEngine::QObjectWrapOption> & >::toCpp(pyargs[2]);
                // newQObject(QObject*,QScriptEngine::ValueOwnership,QFlags<QScriptEngine::QObjectWrapOption>)
                QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
                QScriptValue cpp_result = cppSelf->QScriptEngine::newQObject(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQScriptEngineFunc_newQObject_TypeError;
        } else goto SbkQScriptEngineFunc_newQObject_TypeError;
    } else goto SbkQScriptEngineFunc_newQObject_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_newQObject_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtScript.QScriptEngine.ValueOwnership = QtOwnership, PySide.QtScript.QScriptEngine.QObjectWrapOptions = 0", "PySide.QtScript.QScriptValue, PySide.QtCore.QObject, PySide.QtScript.QScriptEngine.ValueOwnership = QtOwnership, PySide.QtScript.QScriptEngine.QObjectWrapOptions = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptEngine.newQObject", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_newRegExp(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "newRegExp", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // newRegExp(QString,QString)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::newRegExp(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRegExp & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QRegExp* cpp_arg0 = Shiboken::Converter<QRegExp* >::toCpp(pyargs[0]);
        // newRegExp(QRegExp)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::newRegExp(*cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_newRegExp_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_newRegExp_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRegExp", "PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptEngine.newRegExp", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_newVariant(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "newVariant", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QVariant & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg0_auto_ptr;
        QVariant* cpp_arg0 = Shiboken::Converter<QVariant* >::toCpp(pyargs[0]);
        if (!SbkQVariant_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QVariant >(cpp_arg0);
        // newVariant(QVariant)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::newVariant(*cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[0]);
        if (!SbkQScriptValue_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // newVariant(QScriptValue,QVariant)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::newVariant(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_newVariant_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_newVariant_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue, PySide.QtCore.QVariant", "PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptEngine.newVariant", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_nullValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // nullValue()
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptEngine::nullValue();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_objectById(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // objectById(qint64)const
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::objectById(cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_objectById_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_objectById_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.objectById", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_popContext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // popContext()
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    cppSelf->QScriptEngine::popContext();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQScriptEngineFunc_processEventsInterval(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // processEventsInterval()const
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QScriptEngine::processEventsInterval();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_pushContext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pushContext()
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    QScriptContext * cpp_result = cppSelf->QScriptEngine::pushContext();
    py_result = Shiboken::Converter<QScriptContext * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_setAgent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScriptEngineAgent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QScriptEngineAgent* cpp_arg0 = Shiboken::Converter<QScriptEngineAgent* >::toCpp(arg);
        // setAgent(QScriptEngineAgent*)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        cppSelf->QScriptEngine::setAgent(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_setAgent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptEngineFunc_setAgent_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptEngineAgent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.setAgent", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_setDefaultPrototype(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setDefaultPrototype", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QScriptValue & >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg1_auto_ptr;
        QScriptValue* cpp_arg1 = Shiboken::Converter<QScriptValue* >::toCpp(pyargs[1]);
        if (!SbkQScriptValue_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg1);
        // setDefaultPrototype(int,QScriptValue)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        cppSelf->QScriptEngine::setDefaultPrototype(cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_setDefaultPrototype_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptEngineFunc_setDefaultPrototype_TypeError:
        const char* overloads[] = {"int, PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptEngine.setDefaultPrototype", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_setGlobalObject(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // setGlobalObject(QScriptValue)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        cppSelf->QScriptEngine::setGlobalObject(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_setGlobalObject_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptEngineFunc_setGlobalObject_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.setGlobalObject", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_setProcessEventsInterval(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setProcessEventsInterval(int)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        cppSelf->QScriptEngine::setProcessEventsInterval(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_setProcessEventsInterval_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQScriptEngineFunc_setProcessEventsInterval_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.setProcessEventsInterval", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_toObject(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QScriptValue & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QScriptValue > cpp_arg0_auto_ptr;
        QScriptValue* cpp_arg0 = Shiboken::Converter<QScriptValue* >::toCpp(arg);
        if (!SbkQScriptValue_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QScriptValue >(cpp_arg0);
        // toObject(QScriptValue)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptValue cpp_result = cppSelf->QScriptEngine::toObject(*cpp_arg0);
        py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_toObject_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_toObject_TypeError:
        const char* overloads[] = {"PySide.QtScript.QScriptValue", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.toObject", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_toStringHandle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // toStringHandle(QString)
        QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
        QScriptString cpp_result = cppSelf->QScriptEngine::toStringHandle(*cpp_arg0);
        py_result = Shiboken::Converter<QScriptString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptEngineFunc_toStringHandle_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQScriptEngineFunc_toStringHandle_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtScript.QScriptEngine.toStringHandle", overloads);
        return 0;
}

static PyObject* SbkQScriptEngineFunc_uncaughtException(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // uncaughtException()const
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptEngine::uncaughtException();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_uncaughtExceptionBacktrace(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // uncaughtExceptionBacktrace()const
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QScriptEngine::uncaughtExceptionBacktrace();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_uncaughtExceptionLineNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // uncaughtExceptionLineNumber()const
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QScriptEngine::uncaughtExceptionLineNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptEngineFunc_undefinedValue(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // undefinedValue()
    QScriptEngine* cppSelf = Shiboken::Converter<QScriptEngine* >::toCpp((PyObject*)self);
    QScriptValue cpp_result = cppSelf->QScriptEngine::undefinedValue();
    py_result = Shiboken::Converter<QScriptValue >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQScriptEngine_methods[] = {
    {"abortEvaluation", (PyCFunction)SbkQScriptEngineFunc_abortEvaluation, METH_NOARGS|METH_O},
    {"agent", (PyCFunction)SbkQScriptEngineFunc_agent, METH_NOARGS},
    {"availableExtensions", (PyCFunction)SbkQScriptEngineFunc_availableExtensions, METH_NOARGS},
    {"canEvaluate", (PyCFunction)SbkQScriptEngineFunc_canEvaluate, METH_O},
    {"clearExceptions", (PyCFunction)SbkQScriptEngineFunc_clearExceptions, METH_NOARGS},
    {"collectGarbage", (PyCFunction)SbkQScriptEngineFunc_collectGarbage, METH_NOARGS},
    {"currentContext", (PyCFunction)SbkQScriptEngineFunc_currentContext, METH_NOARGS},
    {"defaultPrototype", (PyCFunction)SbkQScriptEngineFunc_defaultPrototype, METH_O},
    {"evaluate", (PyCFunction)SbkQScriptEngineFunc_evaluate, METH_VARARGS},
    {"globalObject", (PyCFunction)SbkQScriptEngineFunc_globalObject, METH_NOARGS},
    {"hasUncaughtException", (PyCFunction)SbkQScriptEngineFunc_hasUncaughtException, METH_NOARGS},
    {"importExtension", (PyCFunction)SbkQScriptEngineFunc_importExtension, METH_O},
    {"importedExtensions", (PyCFunction)SbkQScriptEngineFunc_importedExtensions, METH_NOARGS},
    {"installTranslatorFunctions", (PyCFunction)SbkQScriptEngineFunc_installTranslatorFunctions, METH_NOARGS|METH_O},
    {"isEvaluating", (PyCFunction)SbkQScriptEngineFunc_isEvaluating, METH_NOARGS},
    {"newActivationObject", (PyCFunction)SbkQScriptEngineFunc_newActivationObject, METH_NOARGS},
    {"newArray", (PyCFunction)SbkQScriptEngineFunc_newArray, METH_NOARGS|METH_O},
    {"newDate", (PyCFunction)SbkQScriptEngineFunc_newDate, METH_O},
    {"newObject", (PyCFunction)SbkQScriptEngineFunc_newObject, METH_VARARGS},
    {"newQMetaObject", (PyCFunction)SbkQScriptEngineFunc_newQMetaObject, METH_VARARGS},
    {"newQObject", (PyCFunction)SbkQScriptEngineFunc_newQObject, METH_VARARGS},
    {"newRegExp", (PyCFunction)SbkQScriptEngineFunc_newRegExp, METH_VARARGS},
    {"newVariant", (PyCFunction)SbkQScriptEngineFunc_newVariant, METH_VARARGS},
    {"nullValue", (PyCFunction)SbkQScriptEngineFunc_nullValue, METH_NOARGS},
    {"objectById", (PyCFunction)SbkQScriptEngineFunc_objectById, METH_O},
    {"popContext", (PyCFunction)SbkQScriptEngineFunc_popContext, METH_NOARGS},
    {"processEventsInterval", (PyCFunction)SbkQScriptEngineFunc_processEventsInterval, METH_NOARGS},
    {"pushContext", (PyCFunction)SbkQScriptEngineFunc_pushContext, METH_NOARGS},
    {"setAgent", (PyCFunction)SbkQScriptEngineFunc_setAgent, METH_O},
    {"setDefaultPrototype", (PyCFunction)SbkQScriptEngineFunc_setDefaultPrototype, METH_VARARGS},
    {"setGlobalObject", (PyCFunction)SbkQScriptEngineFunc_setGlobalObject, METH_O},
    {"setProcessEventsInterval", (PyCFunction)SbkQScriptEngineFunc_setProcessEventsInterval, METH_O},
    {"toObject", (PyCFunction)SbkQScriptEngineFunc_toObject, METH_O},
    {"toStringHandle", (PyCFunction)SbkQScriptEngineFunc_toStringHandle, METH_O},
    {"uncaughtException", (PyCFunction)SbkQScriptEngineFunc_uncaughtException, METH_NOARGS},
    {"uncaughtExceptionBacktrace", (PyCFunction)SbkQScriptEngineFunc_uncaughtExceptionBacktrace, METH_NOARGS},
    {"uncaughtExceptionLineNumber", (PyCFunction)SbkQScriptEngineFunc_uncaughtExceptionLineNumber, METH_NOARGS},
    {"undefinedValue", (PyCFunction)SbkQScriptEngineFunc_undefinedValue, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQScriptEngine_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtScript.QScriptEngine",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQScriptEngine_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQScriptEngine_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QScriptEngine >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtScript_QScriptEngine_ValueOwnership_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtScript_QScriptEngine_ValueOwnership_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtScript_QScriptEngine_ValueOwnership_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ValueOwnership",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtScript_QScriptEngine_ValueOwnership_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtScript_QScriptEngine_ValueOwnership_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtScript_QScriptEngine_ValueOwnership_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject*
SbkPySide_QtScript_QScriptEngine_QObjectWrapOption___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QScriptEngine::QObjectWrapOptions >::toPython(
        ((QScriptEngine::QObjectWrapOptions) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QScriptEngine::QObjectWrapOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtScript_QScriptEngine_QObjectWrapOption___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QScriptEngine::QObjectWrapOptions >::toPython(
        ((QScriptEngine::QObjectWrapOptions) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QScriptEngine::QObjectWrapOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtScript_QScriptEngine_QObjectWrapOption___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QScriptEngine::QObjectWrapOptions >::toPython(
        ((QScriptEngine::QObjectWrapOptions) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QScriptEngine::QObjectWrapOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtScript_QScriptEngine_QObjectWrapOption___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QScriptEngine::QObjectWrapOptions >::toPython(
        ~ Shiboken::Converter< QScriptEngine::QObjectWrapOptions >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtScript_QScriptEngine_QObjectWrapOption___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtScript_QScriptEngine_QObjectWrapOption___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtScript_QScriptEngine_QObjectWrapOption___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtScript_QScriptEngine_QObjectWrapOption___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QObjectWrapOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtScript_QScriptEngine_QObjectWrapOptions_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtScript_QScriptEngine_QObjectWrapOptions_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QObjectWrapOptions",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtScript_QScriptEngine_QObjectWrapOptions_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtScript_QScriptEngine_QObjectWrapOptions_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtScript_QScriptEngine_QObjectWrapOptions_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QScriptEngine(PyObject* module)
{
    SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQScriptEngine_Type);

    SbkQScriptEngine_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQScriptEngine_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQScriptEngine_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQScriptEngine_Type));
    PyModule_AddObject(module, "QScriptEngine",
        ((PyObject*)&SbkQScriptEngine_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ValueOwnership
    SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINE_VALUEOWNERSHIP_IDX] = &SbkPySide_QtScript_QScriptEngine_ValueOwnership_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtScript_QScriptEngine_ValueOwnership_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtScript_QScriptEngine_ValueOwnership_Type);
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
            "ValueOwnership",((PyObject*)&SbkPySide_QtScript_QScriptEngine_ValueOwnership_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptEngine_ValueOwnership_Type,
        (long) QScriptEngine::QtOwnership, "QtOwnership");
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
        "QtOwnership", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptEngine_ValueOwnership_Type.tp_dict,
        "QtOwnership", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptEngine_ValueOwnership_Type,
        (long) QScriptEngine::ScriptOwnership, "ScriptOwnership");
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
        "ScriptOwnership", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptEngine_ValueOwnership_Type.tp_dict,
        "ScriptOwnership", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptEngine_ValueOwnership_Type,
        (long) QScriptEngine::AutoOwnership, "AutoOwnership");
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
        "AutoOwnership", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptEngine_ValueOwnership_Type.tp_dict,
        "AutoOwnership", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QScriptEngine::ValueOwnership");

    // init enum class: QObjectWrapOption
    SbkPySide_QtScriptTypes[SBK_QSCRIPTENGINE_QOBJECTWRAPOPTION_IDX] = &SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type);
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
            "QObjectWrapOption",((PyObject*)&SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type));

    // init flags class: QFlags<QScriptEngine::QObjectWrapOption>
    SbkPySide_QtScriptTypes[SBK_QFLAGS_QSCRIPTENGINE_QOBJECTWRAPOPTION__IDX] = &SbkPySide_QtScript_QScriptEngine_QObjectWrapOptions_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtScript_QScriptEngine_QObjectWrapOptions_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtScript_QScriptEngine_QObjectWrapOptions_Type);
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
            "QObjectWrapOptions",((PyObject*)&SbkPySide_QtScript_QScriptEngine_QObjectWrapOptions_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type,
        (long) QScriptEngine::ExcludeChildObjects, "ExcludeChildObjects");
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
        "ExcludeChildObjects", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type.tp_dict,
        "ExcludeChildObjects", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type,
        (long) QScriptEngine::ExcludeSuperClassMethods, "ExcludeSuperClassMethods");
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
        "ExcludeSuperClassMethods", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type.tp_dict,
        "ExcludeSuperClassMethods", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type,
        (long) QScriptEngine::ExcludeSuperClassProperties, "ExcludeSuperClassProperties");
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
        "ExcludeSuperClassProperties", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type.tp_dict,
        "ExcludeSuperClassProperties", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type,
        (long) QScriptEngine::ExcludeSuperClassContents, "ExcludeSuperClassContents");
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
        "ExcludeSuperClassContents", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type.tp_dict,
        "ExcludeSuperClassContents", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type,
        (long) QScriptEngine::SkipMethodsInEnumeration, "SkipMethodsInEnumeration");
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
        "SkipMethodsInEnumeration", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type.tp_dict,
        "SkipMethodsInEnumeration", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type,
        (long) QScriptEngine::ExcludeDeleteLater, "ExcludeDeleteLater");
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
        "ExcludeDeleteLater", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type.tp_dict,
        "ExcludeDeleteLater", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type,
        (long) QScriptEngine::AutoCreateDynamicProperties, "AutoCreateDynamicProperties");
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
        "AutoCreateDynamicProperties", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type.tp_dict,
        "AutoCreateDynamicProperties", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type,
        (long) QScriptEngine::PreferExistingWrapperObject, "PreferExistingWrapperObject");
    PyDict_SetItemString(SbkQScriptEngine_Type.super.ht_type.tp_dict,
        "PreferExistingWrapperObject", enum_item);
    PyDict_SetItemString(SbkPySide_QtScript_QScriptEngine_QObjectWrapOption_Type.tp_dict,
        "PreferExistingWrapperObject", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QScriptEngine::QObjectWrapOption");

    Shiboken::TypeResolver::createObjectTypeResolver<QScriptEngine >("QScriptEngine*");
    Shiboken::TypeResolver::createObjectTypeResolver<QScriptEngine >(typeid(QScriptEngine).name());
}


} // extern "C"

