/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qhostaddress_wrapper.h"

// Extra includes
#include <QPair>
#include <qdatastream.h>
#include <qhostaddress.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQHostAddress_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QHostAddress* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QHostAddress", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QHostAddress()
        cptr = new QHostAddress();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QHostAddress(QString)
        cptr = new QHostAddress(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QIPv6Address & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QIPv6Address* cpp_arg0 = Shiboken::Converter<QIPv6Address* >::toCpp(pyargs[0]);
        // QHostAddress(QIPv6Address)
        cptr = new QHostAddress(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QHostAddress::SpecialAddress >::isConvertible(pyargs[0])) {
        QHostAddress::SpecialAddress cpp_arg0 = Shiboken::Converter<QHostAddress::SpecialAddress >::toCpp(pyargs[0]);
        // QHostAddress(QHostAddress::SpecialAddress)
        cptr = new QHostAddress(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && PyNumber_Check(pyargs[0])) {
        quint32 cpp_arg0 = Shiboken::Converter<quint32 >::toCpp(pyargs[0]);
        // QHostAddress(quint32)
        cptr = new QHostAddress(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QHostAddress & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QHostAddress > cpp_arg0_auto_ptr;
        QHostAddress* cpp_arg0 = Shiboken::Converter<QHostAddress* >::toCpp(pyargs[0]);
        if (!SbkQHostAddress_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QHostAddress >(cpp_arg0);
        // QHostAddress(QHostAddress)
        cptr = new QHostAddress(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHostAddress_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QHostAddress >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQHostAddress_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQHostAddress_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtNetwork.QHostAddress.SpecialAddress", "PySide.QtNetwork.QHostAddress", "PySide.QtNetwork.QIPv6Address", "PySide.QtCore.QString", "unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHostAddress", overloads);
        return -1;
}

static PyObject* SbkQHostAddressFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
    cppSelf->QHostAddress::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQHostAddressFunc_isInSubnet(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isInSubnet", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QHostAddress & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QHostAddress > cpp_arg0_auto_ptr;
        QHostAddress* cpp_arg0 = Shiboken::Converter<QHostAddress* >::toCpp(pyargs[0]);
        if (!SbkQHostAddress_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QHostAddress >(cpp_arg0);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // isInSubnet(QHostAddress,int)const
        QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHostAddress::isInSubnet(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPair<QHostAddress, int >  >::isConvertible(pyargs[0])) {
        QPair<QHostAddress, int >  cpp_arg0 = Shiboken::Converter<QPair<QHostAddress, int >  >::toCpp(pyargs[0]);
        // isInSubnet(QPair<QHostAddress,int>)const
        QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHostAddress::isInSubnet(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHostAddressFunc_isInSubnet_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQHostAddressFunc_isInSubnet_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QHostAddress, int", "QPair", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QHostAddress.isInSubnet", overloads);
        return 0;
}

static PyObject* SbkQHostAddressFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QHostAddress::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHostAddressFunc_parseSubnet(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // parseSubnet(QString)
        QPair<QHostAddress, int > cpp_result = QHostAddress::parseSubnet(*cpp_arg0);
        py_result = Shiboken::Converter<QPair<QHostAddress, int > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHostAddressFunc_parseSubnet_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQHostAddressFunc_parseSubnet_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHostAddress.parseSubnet", overloads);
        return 0;
}

static PyObject* SbkQHostAddressFunc_protocol(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // protocol()const
    QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
    QAbstractSocket::NetworkLayerProtocol cpp_result = cppSelf->QHostAddress::protocol();
    py_result = Shiboken::Converter<QAbstractSocket::NetworkLayerProtocol >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHostAddressFunc_scopeId(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // scopeId()const
    QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QHostAddress::scopeId();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHostAddressFunc_setAddress(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<quint8 * >::isConvertible(arg)) {
        quint8 * cpp_arg0 = Shiboken::Converter<quint8 * >::toCpp(arg);
        // setAddress(quint8*)
        QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
        cppSelf->QHostAddress::setAddress(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else if (PyNumber_Check(arg)) {
        quint32 cpp_arg0 = Shiboken::Converter<quint32 >::toCpp(arg);
        // setAddress(quint32)
        QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
        cppSelf->QHostAddress::setAddress(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setAddress(QString)
        QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QHostAddress::setAddress(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QIPv6Address & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QIPv6Address* cpp_arg0 = Shiboken::Converter<QIPv6Address* >::toCpp(arg);
        // setAddress(QIPv6Address)
        QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
        cppSelf->QHostAddress::setAddress(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else goto SbkQHostAddressFunc_setAddress_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQHostAddressFunc_setAddress_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QIPv6Address", "PySide.QtCore.QString", "unsigned int", "quint8", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHostAddress.setAddress", overloads);
        return 0;
}

static PyObject* SbkQHostAddressFunc_setScopeId(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setScopeId(QString)
        QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
        cppSelf->QHostAddress::setScopeId(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQHostAddressFunc_setScopeId_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQHostAddressFunc_setScopeId_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHostAddress.setScopeId", overloads);
        return 0;
}

static PyObject* SbkQHostAddressFunc_toIPv4Address(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toIPv4Address()const
    QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
    quint32 cpp_result = cppSelf->QHostAddress::toIPv4Address();
    py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHostAddressFunc_toIPv6Address(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toIPv6Address()const
    QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
    QIPv6Address cpp_result = cppSelf->QHostAddress::toIPv6Address();
    py_result = Shiboken::Converter<QIPv6Address >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQHostAddressFunc_toString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toString()const
    QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QHostAddress::toString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQHostAddress_methods[] = {
    {"clear", (PyCFunction)SbkQHostAddressFunc_clear, METH_NOARGS},
    {"isInSubnet", (PyCFunction)SbkQHostAddressFunc_isInSubnet, METH_VARARGS},
    {"isNull", (PyCFunction)SbkQHostAddressFunc_isNull, METH_NOARGS},
    {"parseSubnet", (PyCFunction)SbkQHostAddressFunc_parseSubnet, METH_O|METH_STATIC},
    {"protocol", (PyCFunction)SbkQHostAddressFunc_protocol, METH_NOARGS},
    {"scopeId", (PyCFunction)SbkQHostAddressFunc_scopeId, METH_NOARGS},
    {"setAddress", (PyCFunction)SbkQHostAddressFunc_setAddress, METH_O},
    {"setScopeId", (PyCFunction)SbkQHostAddressFunc_setScopeId, METH_O},
    {"toIPv4Address", (PyCFunction)SbkQHostAddressFunc_toIPv4Address, METH_NOARGS},
    {"toIPv6Address", (PyCFunction)SbkQHostAddressFunc_toIPv6Address, METH_NOARGS},
    {"toString", (PyCFunction)SbkQHostAddressFunc_toString, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQHostAddressFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQHostAddress_Check(arg) && !SbkQHostAddress_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QHostAddress) [reverse operator]
        QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQHostAddressFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQHostAddressFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHostAddress.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQHostAddressFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQHostAddress_Check(arg) && !SbkQHostAddress_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QHostAddress&) [reverse operator]
        QHostAddress* cppSelf = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQHostAddressFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQHostAddressFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QHostAddress.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQHostAddress_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQHostAddressFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQHostAddressFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQHostAddress_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QHostAddress& cpp_self = *Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QHostAddress::SpecialAddress >::isConvertible(other)) {
                // operator!=(QHostAddress::SpecialAddress address) const
                QHostAddress::SpecialAddress cpp_other = Shiboken::Converter<QHostAddress::SpecialAddress >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else if (Shiboken::Converter<QHostAddress & >::isConvertible(other)) {
                // operator!=(const QHostAddress & address) const
                QHostAddress* cpp_other = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QHostAddress  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QHostAddress >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QHostAddress > cpp_other_auto_ptr;
                QHostAddress* cpp_other = Shiboken::Converter<QHostAddress* >::toCpp(other);
                if (!SbkQHostAddress_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QHostAddress >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQHostAddress_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QHostAddress::SpecialAddress >::isConvertible(other)) {
                // operator==(QHostAddress::SpecialAddress address) const
                QHostAddress::SpecialAddress cpp_other = Shiboken::Converter<QHostAddress::SpecialAddress >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else if (Shiboken::Converter<QHostAddress::SpecialAddress >::isConvertible(other)) {
                // operator==(QHostAddress::SpecialAddress address1)
                QHostAddress::SpecialAddress cpp_other = Shiboken::Converter<QHostAddress::SpecialAddress >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else if (Shiboken::Converter<QHostAddress & >::isConvertible(other)) {
                // operator==(const QHostAddress & address) const
                QHostAddress* cpp_other = Shiboken::Converter<QHostAddress* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QHostAddress  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QHostAddress >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QHostAddress > cpp_other_auto_ptr;
                QHostAddress* cpp_other = Shiboken::Converter<QHostAddress* >::toCpp(other);
                if (!SbkQHostAddress_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QHostAddress >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQHostAddress_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQHostAddress_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

static long SbkQHostAddress_HashFunc(PyObject* obj){
    return qHash(Shiboken::Converter<QHostAddress >::toCpp(obj));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQHostAddress_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QHostAddress",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQHostAddress_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             &SbkQHostAddress_HashFunc,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQHostAddress_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQHostAddress_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQHostAddress_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QHostAddress >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtNetwork_QHostAddress_SpecialAddress_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtNetwork_QHostAddress_SpecialAddress_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SpecialAddress",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtNetwork_QHostAddress_SpecialAddress_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtNetwork_QHostAddress_SpecialAddress_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtNetwork_QHostAddress_SpecialAddress_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QHostAddress(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QHOSTADDRESS_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQHostAddress_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQHostAddress_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQHostAddress_Type));
    PyModule_AddObject(module, "QHostAddress",
        ((PyObject*)&SbkQHostAddress_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SpecialAddress
    SbkPySide_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX] = &SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type);
    PyDict_SetItemString(SbkQHostAddress_Type.super.ht_type.tp_dict,
            "SpecialAddress",((PyObject*)&SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type,
        (long) QHostAddress::Null, "Null");
    PyDict_SetItemString(SbkQHostAddress_Type.super.ht_type.tp_dict,
        "Null", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type.tp_dict,
        "Null", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type,
        (long) QHostAddress::Broadcast, "Broadcast");
    PyDict_SetItemString(SbkQHostAddress_Type.super.ht_type.tp_dict,
        "Broadcast", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type.tp_dict,
        "Broadcast", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type,
        (long) QHostAddress::LocalHost, "LocalHost");
    PyDict_SetItemString(SbkQHostAddress_Type.super.ht_type.tp_dict,
        "LocalHost", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type.tp_dict,
        "LocalHost", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type,
        (long) QHostAddress::LocalHostIPv6, "LocalHostIPv6");
    PyDict_SetItemString(SbkQHostAddress_Type.super.ht_type.tp_dict,
        "LocalHostIPv6", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type.tp_dict,
        "LocalHostIPv6", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type,
        (long) QHostAddress::Any, "Any");
    PyDict_SetItemString(SbkQHostAddress_Type.super.ht_type.tp_dict,
        "Any", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type.tp_dict,
        "Any", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type,
        (long) QHostAddress::AnyIPv6, "AnyIPv6");
    PyDict_SetItemString(SbkQHostAddress_Type.super.ht_type.tp_dict,
        "AnyIPv6", enum_item);
    PyDict_SetItemString(SbkPySide_QtNetwork_QHostAddress_SpecialAddress_Type.tp_dict,
        "AnyIPv6", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QHostAddress::SpecialAddress");

    Shiboken::TypeResolver::createValueTypeResolver<QHostAddress >("QHostAddress");
    Shiboken::TypeResolver::createValueTypeResolver<QHostAddress >(typeid(QHostAddress).name());
}


} // extern "C"

