/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtmultimedia_python.h"

#include "qvideoframe_wrapper.h"

// Extra includes
#include <qabstractvideobuffer.h>
#include <qimage.h>
#include <qsize.h>
#include <qvariant.h>
#include <qvideoframe.h>

using namespace Shiboken;

static int
SbkQVideoFrame_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QVideoFrame* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQVideoFrame_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QVideoFrame", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QVideoFrame()
        cptr = new QVideoFrame();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 4 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QSize & >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2]) && Shiboken::Converter<QVideoFrame::PixelFormat >::isConvertible(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QSize* cpp_arg1 = Shiboken::Converter<QSize* >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        QVideoFrame::PixelFormat cpp_arg3 = Shiboken::Converter<QVideoFrame::PixelFormat >::toCpp(pyargs[3]);
        // QVideoFrame(int,QSize,int,QVideoFrame::PixelFormat)
        cptr = new QVideoFrame(cpp_arg0, *cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QVideoFrame & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QVideoFrame* cpp_arg0 = Shiboken::Converter<QVideoFrame* >::toCpp(pyargs[0]);
        // QVideoFrame(QVideoFrame)
        cptr = new QVideoFrame(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QImage & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(pyargs[0]);
        // QVideoFrame(QImage)
        cptr = new QVideoFrame(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 3 && Shiboken::Converter<QAbstractVideoBuffer * >::isConvertible(pyargs[0]) && Shiboken::Converter<QSize & >::isConvertible(pyargs[1]) && Shiboken::Converter<QVideoFrame::PixelFormat >::isConvertible(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QAbstractVideoBuffer* cpp_arg0 = Shiboken::Converter<QAbstractVideoBuffer* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QSize* cpp_arg1 = Shiboken::Converter<QSize* >::toCpp(pyargs[1]);
        QVideoFrame::PixelFormat cpp_arg2 = Shiboken::Converter<QVideoFrame::PixelFormat >::toCpp(pyargs[2]);
        // QVideoFrame(QAbstractVideoBuffer*,QSize,QVideoFrame::PixelFormat)
        cptr = new QVideoFrame(cpp_arg0, *cpp_arg1, cpp_arg2);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoFrame_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QVideoFrame >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQVideoFrame_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQVideoFrame_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtMultimedia.QAbstractVideoBuffer, PySide.QtCore.QSize, PySide.QtMultimedia.QVideoFrame.PixelFormat", "PySide.QtGui.QImage", "PySide.QtMultimedia.QVideoFrame", "int, PySide.QtCore.QSize, int, PySide.QtMultimedia.QVideoFrame.PixelFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtMultimedia.QVideoFrame", overloads);
        return -1;
}

static PyObject* SbkQVideoFrameFunc_bits(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bits()
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    uchar * cpp_result = cppSelf->QVideoFrame::bits();
    py_result = Shiboken::Converter<uchar * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_bytesPerLine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bytesPerLine()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QVideoFrame::bytesPerLine();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_endTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // endTime()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QVideoFrame::endTime();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_fieldType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fieldType()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    QVideoFrame::FieldType cpp_result = cppSelf->QVideoFrame::fieldType();
    py_result = Shiboken::Converter<QVideoFrame::FieldType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_handle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handle()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    QVariant cpp_result = cppSelf->QVideoFrame::handle();
    py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_handleType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handleType()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    QAbstractVideoBuffer::HandleType cpp_result = cppSelf->QVideoFrame::handleType();
    py_result = Shiboken::Converter<QAbstractVideoBuffer::HandleType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QVideoFrame::height();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_imageFormatFromPixelFormat(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QVideoFrame::PixelFormat >::isConvertible(arg)) {
        QVideoFrame::PixelFormat cpp_arg0 = Shiboken::Converter<QVideoFrame::PixelFormat >::toCpp(arg);
        // imageFormatFromPixelFormat(QVideoFrame::PixelFormat)
        QImage::Format cpp_result = QVideoFrame::imageFormatFromPixelFormat(cpp_arg0);
        py_result = Shiboken::Converter<QImage::Format >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoFrameFunc_imageFormatFromPixelFormat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVideoFrameFunc_imageFormatFromPixelFormat_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QVideoFrame.PixelFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QVideoFrame.imageFormatFromPixelFormat", overloads);
        return 0;
}

static PyObject* SbkQVideoFrameFunc_isMapped(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isMapped()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QVideoFrame::isMapped();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_isReadable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isReadable()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QVideoFrame::isReadable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QVideoFrame::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_isWritable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isWritable()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QVideoFrame::isWritable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_map(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAbstractVideoBuffer::MapMode >::isConvertible(arg)) {
        QAbstractVideoBuffer::MapMode cpp_arg0 = Shiboken::Converter<QAbstractVideoBuffer::MapMode >::toCpp(arg);
        // map(QAbstractVideoBuffer::MapMode)
        QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QVideoFrame::map(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoFrameFunc_map_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVideoFrameFunc_map_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QAbstractVideoBuffer.MapMode", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QVideoFrame.map", overloads);
        return 0;
}

static PyObject* SbkQVideoFrameFunc_mapMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mapMode()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    QAbstractVideoBuffer::MapMode cpp_result = cppSelf->QVideoFrame::mapMode();
    py_result = Shiboken::Converter<QAbstractVideoBuffer::MapMode >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_mappedBytes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mappedBytes()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QVideoFrame::mappedBytes();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_pixelFormat(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pixelFormat()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    QVideoFrame::PixelFormat cpp_result = cppSelf->QVideoFrame::pixelFormat();
    py_result = Shiboken::Converter<QVideoFrame::PixelFormat >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_pixelFormatFromImageFormat(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QImage::Format >::isConvertible(arg)) {
        QImage::Format cpp_arg0 = Shiboken::Converter<QImage::Format >::toCpp(arg);
        // pixelFormatFromImageFormat(QImage::Format)
        QVideoFrame::PixelFormat cpp_result = QVideoFrame::pixelFormatFromImageFormat(cpp_arg0);
        py_result = Shiboken::Converter<QVideoFrame::PixelFormat >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoFrameFunc_pixelFormatFromImageFormat_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQVideoFrameFunc_pixelFormatFromImageFormat_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImage.Format", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QVideoFrame.pixelFormatFromImageFormat", overloads);
        return 0;
}

static PyObject* SbkQVideoFrameFunc_setEndTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setEndTime(qint64)
        QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
        cppSelf->QVideoFrame::setEndTime(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoFrameFunc_setEndTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVideoFrameFunc_setEndTime_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QVideoFrame.setEndTime", overloads);
        return 0;
}

static PyObject* SbkQVideoFrameFunc_setFieldType(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVideoFrame::FieldType >::isConvertible(arg)) {
        QVideoFrame::FieldType cpp_arg0 = Shiboken::Converter<QVideoFrame::FieldType >::toCpp(arg);
        // setFieldType(QVideoFrame::FieldType)
        QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
        cppSelf->QVideoFrame::setFieldType(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoFrameFunc_setFieldType_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVideoFrameFunc_setFieldType_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QVideoFrame.FieldType", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QVideoFrame.setFieldType", overloads);
        return 0;
}

static PyObject* SbkQVideoFrameFunc_setStartTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setStartTime(qint64)
        QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
        cppSelf->QVideoFrame::setStartTime(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQVideoFrameFunc_setStartTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQVideoFrameFunc_setStartTime_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QVideoFrame.setStartTime", overloads);
        return 0;
}

static PyObject* SbkQVideoFrameFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    QSize cpp_result = cppSelf->QVideoFrame::size();
    py_result = Shiboken::Converter<QSize >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_startTime(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // startTime()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QVideoFrame::startTime();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQVideoFrameFunc_unmap(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // unmap()
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    cppSelf->QVideoFrame::unmap();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQVideoFrameFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QVideoFrame* cppSelf = Shiboken::Converter<QVideoFrame* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QVideoFrame::width();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQVideoFrame_methods[] = {
    {"bits", (PyCFunction)SbkQVideoFrameFunc_bits, METH_NOARGS},
    {"bytesPerLine", (PyCFunction)SbkQVideoFrameFunc_bytesPerLine, METH_NOARGS},
    {"endTime", (PyCFunction)SbkQVideoFrameFunc_endTime, METH_NOARGS},
    {"fieldType", (PyCFunction)SbkQVideoFrameFunc_fieldType, METH_NOARGS},
    {"handle", (PyCFunction)SbkQVideoFrameFunc_handle, METH_NOARGS},
    {"handleType", (PyCFunction)SbkQVideoFrameFunc_handleType, METH_NOARGS},
    {"height", (PyCFunction)SbkQVideoFrameFunc_height, METH_NOARGS},
    {"imageFormatFromPixelFormat", (PyCFunction)SbkQVideoFrameFunc_imageFormatFromPixelFormat, METH_O|METH_STATIC},
    {"isMapped", (PyCFunction)SbkQVideoFrameFunc_isMapped, METH_NOARGS},
    {"isReadable", (PyCFunction)SbkQVideoFrameFunc_isReadable, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQVideoFrameFunc_isValid, METH_NOARGS},
    {"isWritable", (PyCFunction)SbkQVideoFrameFunc_isWritable, METH_NOARGS},
    {"map", (PyCFunction)SbkQVideoFrameFunc_map, METH_O},
    {"mapMode", (PyCFunction)SbkQVideoFrameFunc_mapMode, METH_NOARGS},
    {"mappedBytes", (PyCFunction)SbkQVideoFrameFunc_mappedBytes, METH_NOARGS},
    {"pixelFormat", (PyCFunction)SbkQVideoFrameFunc_pixelFormat, METH_NOARGS},
    {"pixelFormatFromImageFormat", (PyCFunction)SbkQVideoFrameFunc_pixelFormatFromImageFormat, METH_O|METH_STATIC},
    {"setEndTime", (PyCFunction)SbkQVideoFrameFunc_setEndTime, METH_O},
    {"setFieldType", (PyCFunction)SbkQVideoFrameFunc_setFieldType, METH_O},
    {"setStartTime", (PyCFunction)SbkQVideoFrameFunc_setStartTime, METH_O},
    {"size", (PyCFunction)SbkQVideoFrameFunc_size, METH_NOARGS},
    {"startTime", (PyCFunction)SbkQVideoFrameFunc_startTime, METH_NOARGS},
    {"unmap", (PyCFunction)SbkQVideoFrameFunc_unmap, METH_NOARGS},
    {"width", (PyCFunction)SbkQVideoFrameFunc_width, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQVideoFrame_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtMultimedia.QVideoFrame",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQVideoFrame_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQVideoFrame_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QVideoFrame >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtMultimedia_QVideoFrame_FieldType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtMultimedia_QVideoFrame_FieldType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "FieldType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtMultimedia_QVideoFrame_FieldType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtMultimedia_QVideoFrame_FieldType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtMultimedia_QVideoFrame_FieldType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PixelFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QVideoFrame(PyObject* module)
{
    SbkPySide_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQVideoFrame_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQVideoFrame_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQVideoFrame_Type));
    PyModule_AddObject(module, "QVideoFrame",
        ((PyObject*)&SbkQVideoFrame_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: FieldType
    SbkPySide_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX] = &SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type);
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
            "FieldType",((PyObject*)&SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type,
        (long) QVideoFrame::ProgressiveFrame, "ProgressiveFrame");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "ProgressiveFrame", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type.tp_dict,
        "ProgressiveFrame", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type,
        (long) QVideoFrame::TopField, "TopField");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "TopField", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type.tp_dict,
        "TopField", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type,
        (long) QVideoFrame::BottomField, "BottomField");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "BottomField", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type.tp_dict,
        "BottomField", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type,
        (long) QVideoFrame::InterlacedFrame, "InterlacedFrame");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "InterlacedFrame", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_FieldType_Type.tp_dict,
        "InterlacedFrame", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QVideoFrame::FieldType");

    // init enum class: PixelFormat
    SbkPySide_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX] = &SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type);
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
            "PixelFormat",((PyObject*)&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_Invalid, "Format_Invalid");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_Invalid", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_Invalid", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_ARGB32, "Format_ARGB32");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_ARGB32", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_ARGB32", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_ARGB32_Premultiplied, "Format_ARGB32_Premultiplied");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_ARGB32_Premultiplied", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_ARGB32_Premultiplied", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_RGB32, "Format_RGB32");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_RGB32", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_RGB32", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_RGB24, "Format_RGB24");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_RGB24", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_RGB24", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_RGB565, "Format_RGB565");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_RGB565", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_RGB565", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_RGB555, "Format_RGB555");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_RGB555", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_RGB555", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_ARGB8565_Premultiplied, "Format_ARGB8565_Premultiplied");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_ARGB8565_Premultiplied", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_ARGB8565_Premultiplied", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_BGRA32, "Format_BGRA32");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_BGRA32", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_BGRA32", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_BGRA32_Premultiplied, "Format_BGRA32_Premultiplied");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_BGRA32_Premultiplied", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_BGRA32_Premultiplied", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_BGR32, "Format_BGR32");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_BGR32", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_BGR32", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_BGR24, "Format_BGR24");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_BGR24", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_BGR24", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_BGR565, "Format_BGR565");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_BGR565", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_BGR565", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_BGR555, "Format_BGR555");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_BGR555", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_BGR555", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_BGRA5658_Premultiplied, "Format_BGRA5658_Premultiplied");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_BGRA5658_Premultiplied", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_BGRA5658_Premultiplied", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_AYUV444, "Format_AYUV444");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_AYUV444", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_AYUV444", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_AYUV444_Premultiplied, "Format_AYUV444_Premultiplied");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_AYUV444_Premultiplied", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_AYUV444_Premultiplied", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_YUV444, "Format_YUV444");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_YUV444", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_YUV444", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_YUV420P, "Format_YUV420P");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_YUV420P", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_YUV420P", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_YV12, "Format_YV12");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_YV12", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_YV12", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_UYVY, "Format_UYVY");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_UYVY", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_UYVY", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_YUYV, "Format_YUYV");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_YUYV", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_YUYV", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_NV12, "Format_NV12");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_NV12", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_NV12", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_NV21, "Format_NV21");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_NV21", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_NV21", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_IMC1, "Format_IMC1");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_IMC1", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_IMC1", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_IMC2, "Format_IMC2");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_IMC2", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_IMC2", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_IMC3, "Format_IMC3");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_IMC3", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_IMC3", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_IMC4, "Format_IMC4");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_IMC4", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_IMC4", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_Y8, "Format_Y8");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_Y8", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_Y8", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_Y16, "Format_Y16");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_Y16", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_Y16", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type,
        (long) QVideoFrame::Format_User, "Format_User");
    PyDict_SetItemString(SbkQVideoFrame_Type.super.ht_type.tp_dict,
        "Format_User", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QVideoFrame_PixelFormat_Type.tp_dict,
        "Format_User", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QVideoFrame::PixelFormat");

    Shiboken::TypeResolver::createObjectTypeResolver<QVideoFrame >("QVideoFrame*");
    Shiboken::TypeResolver::createObjectTypeResolver<QVideoFrame >(typeid(QVideoFrame).name());
}


} // extern "C"

